/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.mail;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jbpm.JbpmConfiguration;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

class MailTemplates {
    private static final Map templatePropertiesByResource = new HashMap();
    private static final Map templateVariablesByResource = new HashMap();

    MailTemplates() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties getTemplateProperties(String templateName) {
        String resource = JbpmConfiguration.Configs.getString("resource.mail.templates");
        Map map = templatePropertiesByResource;
        synchronized (map) {
            Map templateProperties = (Map)templatePropertiesByResource.get(resource);
            if (templateProperties == null) {
                MailTemplates.loadTemplates(resource);
                templateProperties = (Map)templatePropertiesByResource.get(resource);
            }
            return (Properties)templateProperties.get(templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map getTemplateVariables() {
        String resource = JbpmConfiguration.Configs.getString("resource.mail.templates");
        Map map = templateVariablesByResource;
        synchronized (map) {
            Map templateVariables = (Map)templateVariablesByResource.get(resource);
            if (templateVariables == null) {
                MailTemplates.loadTemplates(resource);
                templateVariables = (Map)templateVariablesByResource.get(resource);
            }
            return templateVariables;
        }
    }

    protected static void loadTemplates(String resource) {
        Element templatesElement = XmlUtil.parseXmlResource(resource, true).getDocumentElement();
        HashMap<String, Properties> templatePropertiesMap = new HashMap<String, Properties>();
        Iterator iter = XmlUtil.elementIterator(templatesElement, "mail-template");
        while (iter.hasNext()) {
            Element templateElement = (Element)iter.next();
            Properties templateProperties = new Properties();
            MailTemplates.addTemplateProperty(templateElement, "to", templateProperties);
            MailTemplates.addTemplateProperty(templateElement, "actors", templateProperties);
            MailTemplates.addTemplateProperty(templateElement, "subject", templateProperties);
            MailTemplates.addTemplateProperty(templateElement, "text", templateProperties);
            MailTemplates.addTemplateProperty(templateElement, "cc", templateProperties);
            MailTemplates.addTemplateProperty(templateElement, "cc-actors", templateProperties);
            MailTemplates.addTemplateProperty(templateElement, "bcc", templateProperties);
            Element bccActorsElement = XmlUtil.element(templateElement, "bccActors");
            if (bccActorsElement != null) {
                templateProperties.setProperty("bcc-actors", XmlUtil.getContentText(bccActorsElement));
            } else {
                MailTemplates.addTemplateProperty(templateElement, "bcc-actors", templateProperties);
            }
            templatePropertiesMap.put(templateElement.getAttribute("name"), templateProperties);
        }
        templatePropertiesByResource.put(resource, templatePropertiesMap);
        HashMap<String, String> templateVariables = new HashMap<String, String>();
        Iterator iter2 = XmlUtil.elementIterator(templatesElement, "variable");
        while (iter2.hasNext()) {
            Element variableElement = (Element)iter2.next();
            templateVariables.put(variableElement.getAttribute("name"), variableElement.getAttribute("value"));
        }
        templateVariablesByResource.put(resource, templateVariables);
    }

    protected static void addTemplateProperty(Element templateElement, String property, Properties templateProperties) {
        Element element = XmlUtil.element(templateElement, property);
        if (element != null) {
            templateProperties.setProperty(property, XmlUtil.getContentText(element));
        }
    }
}

