/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.exe;

import java.io.Serializable;
import java.util.Date;
import org.jbpm.graph.exe.Token;
import org.jbpm.security.SecurityHelper;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class Comment
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id;
    int version;
    protected String actorId;
    protected Date time;
    protected String message;
    protected Token token;
    protected TaskInstance taskInstance;

    public Comment() {
    }

    public Comment(String message) {
        this.actorId = SecurityHelper.getAuthenticatedActorId();
        this.time = new Date();
        this.message = message;
    }

    public Comment(String actorId, String message) {
        this.actorId = actorId;
        this.time = new Date();
        this.message = message;
    }

    public String toString() {
        return "Comment(" + this.message + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)o;
        if (this.id != 0L && this.id == other.getId()) {
            return true;
        }
        return this.message.equals(other.getMessage()) && (this.actorId != null ? this.actorId.equals(other.getActorId()) : other.getActorId() == null) && (this.taskInstance != null ? this.taskInstance.equals(other.getTaskInstance()) : this.token != null && this.token.equals(other.getToken()));
    }

    public int hashCode() {
        int result = 769046417 + this.message.hashCode();
        int n = result = 1770536419 * result + this.actorId != null ? this.actorId.hashCode() : 0;
        if (this.taskInstance != null) {
            result = 55354751 * result + this.taskInstance.hashCode();
        } else if (this.token != null) {
            result = 55354751 * result + this.token.hashCode();
        }
        return result;
    }

    public String getActorId() {
        return this.actorId;
    }

    public long getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getTime() {
        return this.time;
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public Token getToken() {
        return this.token;
    }

    public void setTaskInstance(TaskInstance taskInstance) {
        this.taskInstance = taskInstance;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTime(Date time) {
        this.time = time;
    }
}

