/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;

public class Holiday
implements Serializable {
    private static final long serialVersionUID = 1L;
    final Date startDate;
    final Date endDate;

    public static List parseHolidays(Properties calendarProperties, BusinessCalendar businessCalendar) {
        ArrayList<Holiday> holidays = new ArrayList<Holiday>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(calendarProperties.getProperty("day.format"));
        Iterator<Object> iter = calendarProperties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("holiday")) continue;
            Holiday holiday = new Holiday(calendarProperties.getProperty(key), dateFormat, businessCalendar);
            holidays.add(holiday);
        }
        return holidays;
    }

    public Holiday(String holidayText, DateFormat dateFormat, BusinessCalendar businessCalendar) {
        Date end;
        ParsePosition parsePosition = new ParsePosition(Duration.indexOfNonWhite(holidayText, 0));
        this.startDate = dateFormat.parse(holidayText, parsePosition);
        if (this.startDate == null) {
            throw new IllegalArgumentException("failed to parse holiday start date: " + holidayText);
        }
        int separatorIndex = Duration.indexOfNonWhite(holidayText, parsePosition.getIndex());
        if (separatorIndex != -1) {
            if (holidayText.charAt(separatorIndex) != '-') {
                throw new IllegalArgumentException("expected '-' in holiday date range: " + holidayText);
            }
            parsePosition.setIndex(Duration.indexOfNonWhite(holidayText, separatorIndex + 1));
            end = dateFormat.parse(holidayText, parsePosition);
            if (end == null) {
                throw new IllegalArgumentException("failed to parse holiday end date: " + holidayText);
            }
        } else {
            end = this.startDate;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(end);
        calendar.add(5, 1);
        this.endDate = calendar.getTime();
    }

    public boolean includes(Date date) {
        return this.startDate.getTime() <= date.getTime() && date.getTime() < this.endDate.getTime();
    }
}

