/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.service;

import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.hibernate.Session;
import org.jboss.bpm.api.ProcessNotFoundException;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.ProcessDefinition;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.incubator.service.PersistenceService;
import org.jbpm.integration.spec.service.MutableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoopPersistenceServiceImpl
extends PersistenceService
implements MutableService {
    final Logger log = LoggerFactory.getLogger(NoopPersistenceServiceImpl.class);
    private Map<ObjectName, ProcessDefinition> procDefs = new HashMap<ObjectName, ProcessDefinition>();
    private Map<ObjectName, ProcessInstance> procs = new HashMap<ObjectName, ProcessInstance>();
    private Map<ObjectName, Node> nodes = new HashMap<ObjectName, Node>();

    @Override
    public void setProcessEngine(ProcessEngine engine) {
        super.setProcessEngine(engine);
    }

    public Session createSession() {
        return null;
    }

    public ObjectName saveProcessDefinition(ProcessDefinition procDef) {
        this.procDefs.put(procDef.getKey(), procDef);
        return procDef.getKey();
    }

    public ProcessDefinition loadProcessDefinition(ObjectName procDefID) {
        ProcessDefinition procDef = this.procDefs.get(procDefID);
        if (procDef == null) {
            throw new ProcessNotFoundException("Cannot find process: " + procDefID);
        }
        return procDef;
    }

    public void deleteProcessDefinition(ProcessDefinition procDef) {
        this.procDefs.remove(procDef.getKey());
    }

    public ObjectName saveProcess(ProcessInstance proc) {
        this.procs.put(proc.getKey(), proc);
        for (Node node : proc.getNodes()) {
            this.nodes.put(node.getKey(), node);
        }
        return proc.getKey();
    }

    public ProcessInstance loadProcess(ObjectName procID) {
        ProcessInstance proc = this.procs.get(procID);
        if (proc == null) {
            throw new ProcessNotFoundException("Cannot find process: " + procID);
        }
        return proc;
    }

    public void deleteProcess(ProcessInstance proc) {
        this.procs.remove(proc.getKey());
        for (Node node : proc.getNodes()) {
            this.nodes.remove(node.getKey());
        }
    }

    public ObjectName saveNode(Session session, Node node) {
        return node.getKey();
    }

    public <T extends Node> T loadNode(Session session, Class<T> nodeImpl, ObjectName nodeID) {
        Node node = this.nodes.get(nodeID);
        if (node == null) {
            throw new ProcessNotFoundException("Cannot find node: " + nodeID);
        }
        return (T)node;
    }
}

