/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.form.DateField;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.process.ProcessInstanceList;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.ModelChangeListener;
import org.jboss.bpm.console.client.util.ModelListenerRegistry;
import org.jboss.bpm.console.client.util.ModelModificationCallback;
import org.jboss.bpm.console.client.widgets.FormWidgets;

class ProcessInstanceDetailForm
extends Panel
implements ModelChangeListener {
    private FormPanel detailsForm;
    private ProcessInstanceRef selectedInstance;
    private ModelModificationCallback callback;
    private MainView mainView;
    private Button suspendButton;
    private Button resumeButton;

    public ProcessInstanceDetailForm(MainView view, ModelModificationCallback callback) {
        this.mainView = view;
        this.callback = callback;
        this.setTitle("Instance Details");
        this.setBorder(false);
        this.setFrame(false);
        this.detailsForm = FormWidgets.createBaseFormPanel();
        TextField idField = new TextField("Id", "instanceId", 230);
        idField.setReadOnly(true);
        this.detailsForm.add((Component)idField);
        TextField keyField = new TextField("Key", "key", 230);
        keyField.setReadOnly(true);
        this.detailsForm.add((Component)keyField);
        TextField stateField = new TextField("State", "state", 230);
        stateField.setReadOnly(true);
        this.detailsForm.add((Component)stateField);
        DateField startDateField = new DateField("Start Date", "startDate", 230);
        startDateField.setReadOnly(true);
        this.detailsForm.add((Component)startDateField);
        this.suspendButton = new Button("Suspend", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.resumeButton = new Button("Resume", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.detailsForm.addButton(this.suspendButton);
        this.detailsForm.addButton(this.resumeButton);
        this.add((Component)this.detailsForm);
    }

    private void persistStateChange() {
        String url = this.mainView.getUrlBuilder().getStateChangeURL(this.selectedInstance.getInstanceId(), this.selectedInstance.getState());
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, url);
        try {
            rb.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e1) {
            ConsoleLog.error((String)"Request failed", (Throwable)e1);
        }
    }

    public void onModelChange(ModelListenerRegistry parent, Object changeEvent) {
    }

    public void onRecordChange(ModelListenerRegistry parent, Record record) {
        this.selectedInstance = ProcessInstanceList.transform((Record)record);
        if (this.selectedInstance.isSuspended()) {
            this.suspendButton.disable();
            this.resumeButton.enable();
        } else {
            this.resumeButton.disable();
            this.suspendButton.enable();
        }
        this.detailsForm.getForm().loadRecord(record);
        this.detailsForm.getForm().findField("state").setRawValue(this.selectedInstance.getState().toString());
        this.detailsForm.doLayout();
    }

    public void onReset() {
        this.selectedInstance = null;
        this.detailsForm.getForm().reset();
    }

    static /* synthetic */ ProcessInstanceRef access$000(ProcessInstanceDetailForm x0) {
        return x0.selectedInstance;
    }

    static /* synthetic */ void access$100(ProcessInstanceDetailForm x0) {
        x0.persistStateChange();
    }

    static /* synthetic */ ModelModificationCallback access$200(ProcessInstanceDetailForm x0) {
        return x0.callback;
    }
}

