/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.IntegerFieldDef;
import com.gwtext.client.data.JsonReader;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.MessageBoxConfig;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.RowSelectionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.process.ProcessInstanceListEditor;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.ModelModificationCallback;
import org.jboss.bpm.console.client.widgets.RemoteListView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ProcessDefinitionList
extends RemoteListView {
    private Map<Integer, ProcessDefinitionRef> row2ProcessMap = new HashMap();

    public ProcessDefinitionList(ModelModificationCallback callback, String titleName, MainView view) {
        super(callback, titleName, view, ProcessDefinitionList.getResourceUrl((MainView)view));
        this.enableAddBtn(false);
        RowSelectionModel sm = new RowSelectionModel(true);
        this.setRowSelectionModel(sm);
    }

    private static String getResourceUrl(MainView view) {
        return view.getUrlBuilder().getProcessDefinitionsURL();
    }

    protected ColumnModel createColumnModel() {
        ColumnModel columnModel = new ColumnModel((BaseColumnConfig[])new ColumnConfig[]{new ColumnConfig("Process ID", "processId", 75, true), new ColumnConfig("Name", "name", 300, true, null, "expand"), new ColumnConfig("Version", "version", 75, true)});
        return columnModel;
    }

    protected JsonReader createReader() {
        RecordDef recordDef = new RecordDef(new FieldDef[]{new IntegerFieldDef("processId"), new StringFieldDef("name"), new StringFieldDef("version")});
        JsonReader reader = new JsonReader(recordDef);
        reader.setRoot("definitions");
        reader.setTotalProperty("totalCount");
        reader.setId("processId");
        return reader;
    }

    public void onExamine(int row) {
        ProcessDefinitionRef proc = (ProcessDefinitionRef)this.row2ProcessMap.get(row);
        this.launchEditor(proc);
    }

    public void launchEditor(ProcessDefinitionRef proc) {
        String editorId = ProcessInstanceListEditor.createWidgetID((ProcessDefinitionRef)proc);
        if (this.view.hasEditor(editorId)) {
            this.view.showEditor(editorId);
        } else {
            this.view.addEditor((Editor)new ProcessInstanceListEditor(proc, this.view));
        }
    }

    public void onDelete(int row) {
        MessageBox.show((MessageBoxConfig)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onAdd() {
    }

    protected void onRecordsLoaded(Record[] records) {
        this.row2ProcessMap.clear();
        int i = 0;
        for (Record r : records) {
            Long id = Long.valueOf(r.getAsString("processId"));
            ProcessDefinitionRef pd = new ProcessDefinitionRef(id.longValue(), r.getAsString("name"), r.getAsString("version"));
            this.row2ProcessMap.put(i, pd);
            ++i;
        }
        ConsoleLog.debug((String)("Loaded " + this.row2ProcessMap.size() + " process definitions"));
    }

    public List<ProcessDefinitionRef> getAvailableProcessDefinitions() {
        ArrayList<ProcessDefinitionRef> results = new ArrayList<ProcessDefinitionRef>();
        Iterator keys = this.row2ProcessMap.keySet().iterator();
        while (keys.hasNext()) {
            results.add((ProcessDefinitionRef)this.row2ProcessMap.get(keys.next()));
        }
        return results;
    }

    static /* synthetic */ Map access$000(ProcessDefinitionList x0) {
        return x0.row2ProcessMap;
    }

    static /* synthetic */ MainView access$100(ProcessDefinitionList x0) {
        return x0.view;
    }

    static /* synthetic */ ModelModificationCallback access$200(ProcessDefinitionList x0) {
        return x0.modelModificationCallback;
    }
}

