/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.gwtext.client.core.Margins;
import com.gwtext.client.core.RegionPosition;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.MessageBoxConfig;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Viewport;
import com.gwtext.client.widgets.layout.BorderLayout;
import com.gwtext.client.widgets.layout.BorderLayoutData;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import com.gwtext.client.widgets.layout.LayoutData;
import java.util.List;
import org.jboss.bpm.console.client.Authentication;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.Header;
import org.jboss.bpm.console.client.Menu;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.Workspace;
import org.jboss.bpm.console.client.process.ProcessDefinitionListEditor;
import org.jboss.bpm.console.client.report.OverviewReportEditor;
import org.jboss.bpm.console.client.task.TaskListEditor;
import org.jboss.bpm.console.client.util.ConsoleLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainView
extends Composite {
    private HTML status = new HTML();
    private Header header;
    private Menu menu;
    private Workspace workspace;
    private URLBuilder urlBuilder;
    private Viewport viewport;
    private Authentication auth;
    private ConsoleConfig config;

    public boolean isAttached() {
        return super.isAttached();
    }

    public MainView(Authentication auth, URLBuilder urlBuilder, ConsoleConfig config) {
        this.auth = auth;
        this.config = config;
        this.urlBuilder = urlBuilder;
        Panel mainPanel = this.createMainPanel();
        this.assembleMainApplication(mainPanel);
        this.viewport = new Viewport(mainPanel);
    }

    private Panel createMainPanel() {
        Panel mainPanel = new Panel();
        mainPanel.setBorder(false);
        mainPanel.setPaddings(5);
        mainPanel.setLayout((ContainerLayout)new FitLayout());
        mainPanel.setWidth(1024);
        mainPanel.setHeight(1024);
        return mainPanel;
    }

    private void assembleMainApplication(Panel mainPanel) {
        Panel borderPanel = new Panel();
        borderPanel.setBorder(false);
        borderPanel.setLayout((ContainerLayout)new BorderLayout());
        this.header = new Header(this);
        borderPanel.add((Component)this.header, (LayoutData)new BorderLayoutData(RegionPosition.NORTH));
        this.header.setUserInfo(this.auth.getUsername(), this.auth.getRolesAssigned());
        this.menu = new Menu(this);
        BorderLayoutData menuData = new BorderLayoutData(RegionPosition.WEST);
        menuData.setSplit(false);
        menuData.setMinSize(175);
        menuData.setMaxSize(400);
        menuData.setMargins(new Margins(0, 5, 0, 0));
        borderPanel.add((Component)this.menu, (LayoutData)menuData);
        this.workspace = new Workspace();
        borderPanel.add((Component)this.workspace, (LayoutData)new BorderLayoutData(RegionPosition.CENTER));
        this.workspace.addEditor((Editor)new ProcessDefinitionListEditor(this), false);
        this.workspace.addEditor((Editor)new TaskListEditor(this), false);
        this.workspace.addEditor((Editor)new OverviewReportEditor(this), false);
        mainPanel.add((Component)borderPanel);
    }

    public void addEditor(Editor editor) {
        ConsoleLog.debug((String)("Add editor " + editor.getEditorId()));
        this.workspace.addEditor(editor, true);
    }

    public boolean hasEditor(String id) {
        return this.workspace.hasEditor(id);
    }

    public void showEditor(String id) {
        this.workspace.showTab(id);
    }

    public URLBuilder getUrlBuilder() {
        return this.urlBuilder;
    }

    public void displayMessage(String message, boolean isError) {
        this.status.setText(message);
        MessageBox.show((MessageBoxConfig)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<String> getRolesAssigned() {
        return this.auth.getRolesAssigned();
    }

    public String getUsername() {
        return this.auth.getUsername();
    }

    public void logout() {
        this.auth.doLogout();
    }
}

