/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.MemoryRefStack;
import com.google.gson.NullExclusionStrategy;
import com.google.gson.ObjectNavigator;
import com.google.gson.Preconditions;
import java.lang.reflect.Type;

final class ObjectNavigatorFactory {
    private final ExclusionStrategy strategy;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final MemoryRefStack<Object> stack;

    public ObjectNavigatorFactory(ExclusionStrategy strategy, FieldNamingStrategy fieldNamingPolicy) {
        Preconditions.checkNotNull((Object)fieldNamingPolicy);
        this.strategy = strategy == null ? new NullExclusionStrategy() : strategy;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.stack = new MemoryRefStack();
    }

    public ObjectNavigator create(Object srcObject) {
        return this.create(srcObject, srcObject.getClass());
    }

    public ObjectNavigator create(Object srcObject, Type type) {
        return new ObjectNavigator(srcObject, type, this.strategy, this.stack);
    }

    FieldNamingStrategy getFieldNamingPolicy() {
        return this.fieldNamingPolicy;
    }
}

