/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonArray
extends JsonElement
implements Iterable<JsonElement> {
    private final List<JsonElement> elements = new LinkedList();

    public void add(JsonElement element) {
        this.elements.add(element);
    }

    public void addAll(JsonArray array) {
        this.elements.addAll(array.elements);
    }

    void reverse() {
        Collections.reverse(this.elements);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return this.elements.iterator();
    }

    public JsonElement get(int i) {
        return (JsonElement)this.elements.get(i);
    }

    public Number getAsNumber() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsNumber();
        }
        throw new IllegalStateException();
    }

    public String getAsString() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsString();
        }
        throw new IllegalStateException();
    }

    public double getAsDouble() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsDouble();
        }
        throw new IllegalStateException();
    }

    public BigDecimal getAsBigDecimal() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsBigDecimal();
        }
        throw new IllegalStateException();
    }

    public BigInteger getAsBigInteger() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsBigInteger();
        }
        throw new IllegalStateException();
    }

    public float getAsFloat() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsFloat();
        }
        throw new IllegalStateException();
    }

    public long getAsLong() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsLong();
        }
        throw new IllegalStateException();
    }

    public int getAsInt() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsInt();
        }
        throw new IllegalStateException();
    }

    public short getAsShort() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsShort();
        }
        throw new IllegalStateException();
    }

    public boolean getAsBoolean() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsBoolean();
        }
        throw new IllegalStateException();
    }

    Object getAsObject() {
        if (this.elements.size() == 1) {
            return ((JsonElement)this.elements.get(0)).getAsObject();
        }
        throw new IllegalStateException();
    }

    protected void toString(StringBuilder sb) {
        sb.append('[');
        boolean first = true;
        for (JsonElement element : this.elements) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            element.toString(sb);
        }
        sb.append(']');
    }
}

