/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.DefaultTypeAdapters;
import com.google.gson.DisjunctionExclusionStrategy;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.InnerClassExclusionStrategy;
import com.google.gson.InstanceCreator;
import com.google.gson.JavaFieldNamingPolicy;
import com.google.gson.JsonCompactFormatter;
import com.google.gson.JsonDeserializationContextDefault;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonFormatter;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContextDefault;
import com.google.gson.JsonSerializer;
import com.google.gson.MappedObjectConstructor;
import com.google.gson.ModifierBasedExclusionStrategy;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.ParseException;
import com.google.gson.PrimitiveTypeAdapter;
import com.google.gson.SerializedNameAnnotationInterceptingNamingPolicy;
import com.google.gson.TokenMgrError;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterNotRequired;
import com.google.gson.VersionExclusionStrategy;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class Gson {
    private static final String NULL_STRING = "null";
    static final TypeAdapter DEFAULT_TYPE_ADAPTER = new TypeAdapterNotRequired((TypeAdapter)new PrimitiveTypeAdapter());
    static final ModifierBasedExclusionStrategy DEFAULT_MODIFIER_BASED_EXCLUSION_STRATEGY = new ModifierBasedExclusionStrategy(true, new int[]{128, 8});
    static final JsonFormatter DEFAULT_JSON_FORMATTER = new JsonCompactFormatter();
    static final FieldNamingStrategy DEFAULT_NAMING_POLICY = new SerializedNameAnnotationInterceptingNamingPolicy((FieldNamingStrategy)new JavaFieldNamingPolicy());
    static final Logger logger = Logger.getLogger(Gson.class.getName());
    private final ObjectNavigatorFactory navigatorFactory;
    private final MappedObjectConstructor objectConstructor;
    private final TypeAdapter typeAdapter;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    private final JsonFormatter formatter;
    private final boolean serializeNulls;

    public Gson() {
        this(Gson.createDefaultObjectNavigatorFactory());
    }

    Gson(ObjectNavigatorFactory factory) {
        this(factory, Gson.createObjectConstructor((ParameterizedTypeHandlerMap)DefaultTypeAdapters.DEFAULT_INSTANCE_CREATORS), DEFAULT_TYPE_ADAPTER, DEFAULT_JSON_FORMATTER, false, DefaultTypeAdapters.DEFAULT_SERIALIZERS, DefaultTypeAdapters.DEFAULT_DESERIALIZERS);
    }

    Gson(ObjectNavigatorFactory factory, MappedObjectConstructor objectConstructor, TypeAdapter typeAdapter, JsonFormatter formatter, boolean serializeNulls, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers) {
        this.navigatorFactory = factory;
        this.objectConstructor = objectConstructor;
        this.typeAdapter = typeAdapter;
        this.formatter = formatter;
        this.serializeNulls = serializeNulls;
        this.serializers = serializers;
        this.deserializers = deserializers;
    }

    static MappedObjectConstructor createObjectConstructor(ParameterizedTypeHandlerMap<InstanceCreator<?>> instanceCreators) {
        MappedObjectConstructor objectConstructor = new MappedObjectConstructor();
        for (Map.Entry entry : instanceCreators.entrySet()) {
            objectConstructor.register((Type)entry.getKey(), (InstanceCreator)entry.getValue());
        }
        return objectConstructor;
    }

    private static ObjectNavigatorFactory createDefaultObjectNavigatorFactory() {
        return new ObjectNavigatorFactory(Gson.createExclusionStrategy((double)-1.0), DEFAULT_NAMING_POLICY);
    }

    private static ExclusionStrategy createExclusionStrategy(double version) {
        LinkedList<Object> strategies = new LinkedList<Object>();
        strategies.add(new InnerClassExclusionStrategy());
        strategies.add(DEFAULT_MODIFIER_BASED_EXCLUSION_STRATEGY);
        if (version != -1.0) {
            strategies.add(new VersionExclusionStrategy(version));
        }
        return new DisjunctionExclusionStrategy(strategies);
    }

    public String toJson(Object src) {
        if (src == null) {
            return this.serializeNulls ? "null" : "";
        }
        return this.toJson(src, src.getClass());
    }

    public String toJson(Object src, Type typeOfSrc) {
        StringWriter writer = new StringWriter();
        this.toJson(src, typeOfSrc, (Writer)writer);
        return writer.toString();
    }

    public void toJson(Object src, Writer writer) {
        if (src != null) {
            this.toJson(src, src.getClass(), writer);
        } else if (this.serializeNulls) {
            this.writeOutNullString(writer);
        }
    }

    public void toJson(Object src, Type typeOfSrc, Writer writer) {
        if (src != null) {
            JsonSerializationContextDefault context = new JsonSerializationContextDefault(this.navigatorFactory, this.serializeNulls, this.serializers);
            JsonElement jsonElement = context.serialize(src, typeOfSrc);
            this.formatter.format(jsonElement, new PrintWriter(writer), this.serializeNulls);
        } else if (this.serializeNulls) {
            this.writeOutNullString(writer);
        }
    }

    public <T> T fromJson(String json, Class<T> classOfT) throws JsonParseException {
        Object target = this.fromJson(json, classOfT);
        return (T)target;
    }

    public <T> T fromJson(String json, Type typeOfT) throws JsonParseException {
        StringReader reader = new StringReader(json);
        Object target = this.fromJson((Reader)reader, typeOfT);
        return (T)target;
    }

    public <T> T fromJson(Reader json, Class<T> classOfT) throws JsonParseException {
        T target = classOfT.cast(this.fromJson(json, classOfT));
        return target;
    }

    public <T> T fromJson(Reader json, Type typeOfT) throws JsonParseException {
        try {
            JsonParser parser = new JsonParser(json);
            JsonElement root = parser.parse();
            JsonDeserializationContextDefault context = new JsonDeserializationContextDefault(this.navigatorFactory, this.deserializers, this.objectConstructor, this.typeAdapter);
            Object target = context.deserialize(root, typeOfT);
            return (T)target;
        }
        catch (TokenMgrError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", (Throwable)e);
        }
        catch (ParseException e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", (Throwable)e);
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", (Throwable)e);
        }
    }

    private void writeOutNullString(Writer writer) {
        try {
            writer.append("null");
        }
        catch (IOException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("serializeNulls:").append(this.serializeNulls);
        sb.append(",serializers:").append(this.serializers);
        sb.append(",deserializers:").append(this.deserializers);
        sb.append(",instanceCreators:").append(this.objectConstructor);
        sb.append("}");
        return sb.toString();
    }
}

