/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
@XmlRootElement(name="processDefinition")
public class ProcessDefinitionRef implements IsSerializable
{
   private long processId;
   private String name;
   private String version;

   public ProcessDefinitionRef()
   {
   }

   public ProcessDefinitionRef(long id, String name, String version)
   {
      this.processId = id;
      this.name = name;
      this.version = version;
   }

   @XmlElement(name = "processId")
   public long getProcessId()
   {
      return processId;
   }

   public void setProcessId(long processId)
   {
      this.processId = processId;
   }

   @XmlElement(name = "name")
   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String getVersion()
   {
      return version;
   }

   public void setVersion(String version)
   {
      this.version = version;
   }

   public String toString()
   {
      return "ProcessDefinitionRef{id="+this.processId +", name="+this.name+", version="+this.version+"}";
   }

   public boolean equals(Object o)
   {
      if (this == o) return true;
      if (o == null || getClass() != o.getClass()) return false;

      ProcessDefinitionRef that = (ProcessDefinitionRef) o;

      if (processId != that.processId) return false;
      if (name != null ? !name.equals(that.name) : that.name != null) return false;
      if (version != null ? !version.equals(that.version) : that.version != null) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = (int) (processId ^ (processId >>> 32));
      result = 31 * result + (name != null ? name.hashCode() : 0);
      result = 31 * result + (version != null ? version.hashCode() : 0);
      return result;
   }
}
