/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query.jpa.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.Query;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.jbpm.query.jpa.data.QueryCriteria;
import org.jbpm.query.jpa.data.QueryWhere;

public abstract class QueryCriteriaUtil {
    private Map<Class, Map<String, Attribute>> criteriaAttributes;
    private final AtomicBoolean criteriaAttributesInitialized = new AtomicBoolean(false);

    public QueryCriteriaUtil(Map<Class, Map<String, Attribute>> criteriaAttributes) {
        this.initialize(criteriaAttributes);
    }

    protected QueryCriteriaUtil() {
    }

    protected void initialize(Map<Class, Map<String, Attribute>> criteriaAttributes) {
        this.criteriaAttributes = criteriaAttributes;
    }

    protected Map<Class, Map<String, Attribute>> getCriteriaAttributes() {
        if (!this.criteriaAttributesInitialized.get()) {
            if (this.initializeCriteriaAttributes()) {
                this.criteriaAttributesInitialized.set(true);
            } else {
                throw new IllegalStateException("Queries can not be performed if no persistence unit has been initalized!");
            }
        }
        return this.criteriaAttributes;
    }

    public static <C, I> List<I> convertListToInterfaceList(List<C> internalResult, Class<I> interfaceType) {
        ArrayList<C> result = new ArrayList<C>(internalResult.size());
        for (C element : internalResult) {
            result.add(element);
        }
        return result;
    }

    public static void addCriteria(Map<Class, Map<String, Attribute>> criteriaAttributes, String listId, Attribute attr) {
        Class<?> table = attr.getJavaMember().getDeclaringClass();
        QueryCriteriaUtil.addCriteria(criteriaAttributes, listId, table, attr);
    }

    public static void addCriteria(Map<Class, Map<String, Attribute>> criteriaAttributes, String listId, Class table, Attribute attr) {
        Map<String, Attribute> tableAttrs = criteriaAttributes.get(table);
        if (tableAttrs == null) {
            tableAttrs = new ConcurrentHashMap<String, Attribute>(1);
            criteriaAttributes.put(table, tableAttrs);
        }
        Attribute previousMapping = tableAttrs.put(listId, attr);
        assert (previousMapping == null) : "Previous mapping existed for [" + listId + "]!";
    }

    protected abstract boolean initializeCriteriaAttributes();

    protected abstract CriteriaBuilder getCriteriaBuilder();

    public <T> List<T> doCriteriaQuery(QueryWhere queryWhere, Class<T> queryType) {
        CriteriaBuilder builder = this.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(queryType);
        criteriaQuery.select((Selection)criteriaQuery.from(queryType));
        this.fillCriteriaQuery(criteriaQuery, queryWhere, builder, queryType);
        List<T> result = this.createQueryAndCallApplyMetaCriteriaAndGetResult(queryWhere, criteriaQuery, builder);
        return result;
    }

    protected <R, T> void fillCriteriaQuery(CriteriaQuery<R> query, QueryWhere queryWhere, CriteriaBuilder builder, Class<T> queryType) {
        Predicate queryPredicate = this.createPredicateFromCriteriaList(query, builder, queryType, queryWhere.getCriteria(), queryWhere);
        if (queryPredicate != null) {
            query.where((Expression)queryPredicate);
        }
        if (queryWhere.getAscOrDesc() != null) {
            String orderByListId = queryWhere.getOrderByListId();
            assert (orderByListId != null) : "Ascending boolean is set but no order by list Id has been specified!";
            Expression orderByPath = this.getOrderByExpression(query, queryType, orderByListId);
            Order order = queryWhere.getAscOrDesc() != false ? builder.asc(orderByPath) : builder.desc(orderByPath);
            query.orderBy(new Order[]{order});
        }
    }

    private <R, T> Predicate createPredicateFromCriteriaList(CriteriaQuery<R> query, CriteriaBuilder builder, Class<T> resultType, List<QueryCriteria> inputCriteriaList, QueryWhere queryWhere) {
        Predicate queryPredicate = null;
        if (inputCriteriaList.size() > 1) {
            LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
            QueryCriteria previousCriteria = null;
            QueryCriteria firstCriteria = null;
            LinkedList<QueryCriteria> currentIntersectingCriteriaList = new LinkedList<QueryCriteria>();
            int i = 0;
            for (QueryCriteria criteria : inputCriteriaList) {
                Predicate predicate;
                assert (i++ != 0 || criteria.isFirst()) : "First criteria is not flagged as first!";
                if (criteria.isFirst()) {
                    firstCriteria = previousCriteria = criteria;
                    continue;
                }
                if (firstCriteria != null) {
                    if (criteria.isUnion()) {
                        predicate = this.createPredicateFromSingleOrGroupCriteria(query, builder, resultType, previousCriteria, queryWhere);
                        predicateList.add(predicate);
                    } else {
                        currentIntersectingCriteriaList.add(firstCriteria);
                    }
                    firstCriteria = null;
                }
                if (criteria.isUnion()) {
                    if (previousCriteria != null && !previousCriteria.isUnion() && !currentIntersectingCriteriaList.isEmpty()) {
                        predicate = this.createPredicateFromIntersectingCriteriaList(query, builder, resultType, currentIntersectingCriteriaList, queryWhere);
                        assert (predicate != null) : "Null predicate when evaluating intersecting criteria [" + criteria.toString() + "]";
                        predicateList.add(predicate);
                        currentIntersectingCriteriaList = new LinkedList();
                    }
                    predicate = this.createPredicateFromSingleOrGroupCriteria(query, builder, resultType, criteria, queryWhere);
                    assert (predicate != null) : "Null predicate when evaluating union criteria [" + criteria.toString() + "]";
                    predicateList.add(predicate);
                } else {
                    currentIntersectingCriteriaList.add(criteria);
                }
                previousCriteria = criteria;
            }
            if (!currentIntersectingCriteriaList.isEmpty()) {
                Predicate predicate = this.createPredicateFromIntersectingCriteriaList(query, builder, resultType, currentIntersectingCriteriaList, queryWhere);
                predicateList.add(predicate);
            }
            assert (!predicateList.isEmpty()) : "The predicate list should not (can not?) be empty here!";
            if (predicateList.size() == 1) {
                queryPredicate = (Predicate)predicateList.get(0);
            } else {
                Predicate[] predicates = predicateList.toArray(new Predicate[predicateList.size()]);
                queryPredicate = builder.or(predicates);
            }
        } else if (inputCriteriaList.size() == 1) {
            QueryCriteria singleCriteria = inputCriteriaList.get(0);
            queryPredicate = this.createPredicateFromSingleOrGroupCriteria(query, builder, resultType, singleCriteria, queryWhere);
        }
        return queryPredicate;
    }

    private <R, T> Predicate createPredicateFromIntersectingCriteriaList(CriteriaQuery<R> query, CriteriaBuilder builder, Class<T> queryType, List<QueryCriteria> intersectingCriteriaList, QueryWhere queryWhere) {
        this.combineIntersectingRangeCriteria(intersectingCriteriaList);
        assert (intersectingCriteriaList.size() > 0) : "Empty list of currently intersecting criteria!";
        Predicate[] intersectingPredicates = new Predicate[intersectingCriteriaList.size()];
        int i = 0;
        for (QueryCriteria intersectingCriteria : intersectingCriteriaList) {
            Predicate predicate = this.createPredicateFromSingleOrGroupCriteria(query, builder, queryType, intersectingCriteria, queryWhere);
            assert (predicate != null) : "Null predicate when evaluating individual intersecting criteria [" + intersectingCriteria.toString() + "]";
            intersectingPredicates[i++] = predicate;
        }
        Predicate predicate = intersectingPredicates.length > 1 ? builder.and(intersectingPredicates) : intersectingPredicates[0];
        return predicate;
    }

    private void combineIntersectingRangeCriteria(List<QueryCriteria> intersectionCriteria) {
        HashMap<String, QueryCriteria> intersectingRangeCriteria = new HashMap<String, QueryCriteria>();
        Iterator<QueryCriteria> iter = intersectionCriteria.iterator();
        while (iter.hasNext()) {
            List<Object> values;
            Object[] thisCritValues;
            Object[] prevCritValues;
            QueryCriteria previousCriteria;
            QueryCriteria criteria = iter.next();
            if (!QueryWhere.QueryCriteriaType.RANGE.equals((Object)criteria.getType()) || (previousCriteria = intersectingRangeCriteria.put(criteria.getListId(), criteria)) == null) continue;
            assert (previousCriteria.hasValues() || previousCriteria.hasDateValues()) : "Previous criteria has neither values nor date values!";
            assert (!previousCriteria.hasValues() || !previousCriteria.hasDateValues()) : "Previous criteria has BOTH values and date values!";
            assert (previousCriteria.hasValues() && criteria.hasValues() || previousCriteria.hasDateValues() && criteria.hasDateValues()) : "Previous and current criteria should have either both have values or both have date values!";
            boolean dateValues = false;
            if (previousCriteria.hasValues()) {
                prevCritValues = previousCriteria.getValues().toArray();
                thisCritValues = criteria.getValues().toArray();
            } else {
                dateValues = true;
                prevCritValues = previousCriteria.getDateValues().toArray();
                thisCritValues = criteria.getDateValues().toArray();
            }
            List<Object> list = values = dateValues ? previousCriteria.getDateValues() : previousCriteria.getValues();
            if (prevCritValues[0] == null && thisCritValues[1] == null) {
                values.set(0, (Date)thisCritValues[0]);
                intersectingRangeCriteria.put(previousCriteria.getListId(), previousCriteria);
                iter.remove();
                continue;
            }
            if (prevCritValues[1] != null || thisCritValues[0] != null) continue;
            values.set(1, thisCritValues[1]);
            intersectingRangeCriteria.put(previousCriteria.getListId(), previousCriteria);
            iter.remove();
        }
    }

    private <R, T> Predicate createPredicateFromSingleOrGroupCriteria(CriteriaQuery<R> query, CriteriaBuilder builder, Class<T> queryType, QueryCriteria criteria, QueryWhere queryWhere) {
        Predicate predicate;
        if (criteria.isGroupCriteria()) {
            assert (!criteria.hasValues()) : "Criteria has both subcriteria (group criteria) and values! [" + criteria.toString() + "]";
            predicate = this.createPredicateFromCriteriaList(query, builder, queryType, criteria.getCriteria(), queryWhere);
        } else {
            assert (!criteria.hasCriteria() || Integer.parseInt(criteria.getListId()) < 0) : "Criteria has both values and subcriteria (group criteria)! [" + criteria.toString() + "]";
            predicate = this.createPredicateFromSingleCriteria(query, builder, queryType, criteria, queryWhere);
        }
        return predicate;
    }

    private <R, T> Predicate createPredicateFromSingleCriteria(CriteriaQuery<R> query, CriteriaBuilder builder, Class<T> queryType, QueryCriteria criteria, QueryWhere queryWhere) {
        Predicate predicate = null;
        assert (criteria.hasValues() || criteria.hasDateValues() || Integer.parseInt(criteria.getListId()) < 0) : "No values present for criteria with list id: [" + criteria.getListId() + "]";
        String listId = criteria.getListId();
        Attribute attr = this.getCriteriaAttributes().get(queryType).get(listId);
        if (attr != null) {
            Expression entityField = this.getEntityField(query, listId, attr);
            predicate = QueryCriteriaUtil.basicCreatePredicateFromSingleCriteria(builder, entityField, criteria);
        } else {
            predicate = this.implSpecificCreatePredicateFromSingleCriteria(query, builder, queryType, criteria, queryWhere);
        }
        return predicate;
    }

    public static <T> Root getRoot(AbstractQuery<T> query, Class queryType) {
        Root table = null;
        for (Root root : query.getRoots()) {
            if (!root.getJavaType().equals(queryType)) continue;
            table = root;
            break;
        }
        return table;
    }

    protected <T> Expression getEntityField(CriteriaQuery<T> query, String listId, Attribute attr) {
        return QueryCriteriaUtil.defaultGetEntityField(query, listId, attr);
    }

    public static <T> Expression defaultGetEntityField(CriteriaQuery<T> query, String listId, Attribute attr) {
        Path entityField = null;
        if (attr != null) {
            Class attrType = attr.getDeclaringType().getJavaType();
            for (From from : query.getRoots()) {
                if (!from.getJavaType().equals(attrType) || attr == null) continue;
                if (attr instanceof SingularAttribute) {
                    entityField = from.get((SingularAttribute)attr);
                    break;
                }
                if (attr instanceof PluralAttribute) {
                    entityField = from.get((PluralAttribute)attr);
                    break;
                }
                throw new IllegalStateException("Unexpected attribute type when processing criteria with list id " + listId + ": " + attr.getClass().getName());
            }
        }
        return entityField;
    }

    public static Predicate basicCreatePredicateFromSingleCriteria(CriteriaBuilder builder, Expression entityField, QueryCriteria criteria) {
        Predicate predicate = null;
        List<Object> parameters = criteria.getParameters();
        int numParameters = parameters.size();
        assert (!parameters.isEmpty()) : "Empty parameters for criteria [" + criteria.toString() + "]";
        switch (criteria.getType()) {
            case NORMAL: {
                if (numParameters == 1) {
                    Object parameter = parameters.get(0);
                    assert (parameter != null) : "Null parameter for criteria [" + criteria.toString() + "]";
                    predicate = builder.equal(entityField, parameter);
                    break;
                }
                assert (parameters.get(0) != null) : "Null 1rst parameter for criteria [" + criteria.toString() + "]";
                assert (parameters.get(parameters.size() - 1) != null) : "Null last parameter for criteria [" + criteria.toString() + "]";
                predicate = entityField.in(parameters);
                break;
            }
            case REGEXP: {
                ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
                for (Object param : parameters) {
                    assert (param != null) : "Null regular expression parameter for criteria [" + criteria.toString() + "]";
                    String likeRegex = QueryCriteriaUtil.convertRegexToJPALikeExpression((String)param);
                    Predicate regexPredicate = builder.like(entityField, likeRegex);
                    predicateList.add(regexPredicate);
                }
                if (predicateList.size() == 1) {
                    predicate = (Predicate)predicateList.get(0);
                    break;
                }
                Predicate[] predicates = predicateList.toArray(new Predicate[predicateList.size()]);
                if (criteria.isUnion()) {
                    predicate = builder.or(predicates);
                    break;
                }
                predicate = builder.and(predicates);
                break;
            }
            case RANGE: {
                assert (numParameters > 0 && numParameters < 3) : "Range expressions may only contain between 1 and 2 parameters, not " + numParameters + " [" + criteria.toString() + "]";
                Object[] rangeObjArr = parameters.toArray();
                Class<?> rangeType = rangeObjArr[0] != null ? rangeObjArr[0].getClass() : rangeObjArr[1].getClass();
                predicate = QueryCriteriaUtil.createRangePredicate(builder, entityField, rangeObjArr[0], rangeObjArr[1], rangeType);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown criteria type: " + (Object)((Object)criteria.getType()));
            }
        }
        assert (predicate != null) : "No predicate created when evaluating " + criteria.getType().toString().toLowerCase() + " criteria " + "[" + criteria.toString() + "]";
        return predicate;
    }

    protected static String convertRegexToJPALikeExpression(String regexInput) {
        return regexInput.replace('*', '%').replace('.', '_');
    }

    private static <Y extends Comparable<? super Y>> Predicate createRangePredicate(CriteriaBuilder builder, Expression field, Object start, Object end, Class<Y> rangeType) {
        if (start != null && end != null) {
            return builder.between(field, (Comparable)start, (Comparable)end);
        }
        if (start != null) {
            return builder.greaterThanOrEqualTo(field, (Comparable)start);
        }
        return builder.lessThanOrEqualTo(field, (Comparable)end);
    }

    protected abstract <R, T> Predicate implSpecificCreatePredicateFromSingleCriteria(CriteriaQuery<R> var1, CriteriaBuilder var2, Class var3, QueryCriteria var4, QueryWhere var5);

    protected abstract <T> List<T> createQueryAndCallApplyMetaCriteriaAndGetResult(QueryWhere var1, CriteriaQuery<T> var2, CriteriaBuilder var3);

    public static void applyMetaCriteriaToQuery(Query query, QueryWhere queryWhere) {
        if (queryWhere.getCount() != null) {
            query.setMaxResults(queryWhere.getCount().intValue());
        }
        if (queryWhere.getOffset() != null) {
            query.setFirstResult(queryWhere.getOffset().intValue());
        }
    }

    protected <T, R> Expression getOrderByExpression(CriteriaQuery<R> query, Class<T> queryType, String orderByListId) {
        Attribute field = this.getCriteriaAttributes().get(queryType).get(orderByListId);
        assert (field != null) : "No Attribute found for order-by listId " + orderByListId + " for result type " + queryType.getSimpleName();
        Root table = QueryCriteriaUtil.getRoot(query, queryType);
        assert (table != null) : "Unable to find proper table (Root) instance in query for result type " + queryType.getSimpleName();
        if (!(field instanceof SingularAttribute)) {
            throw new UnsupportedOperationException("Ordering by a join field is not supported!");
        }
        Path orderByPath = table.get((SingularAttribute)field);
        return orderByPath;
    }
}

