/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSearcher {
    private static final Logger log = LoggerFactory.getLogger(LdapSearcher.class);
    public static final String SEARCH_SCOPE = "ldap.search.scope";
    private static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String DEFAULT_SECURITY_AUTHENTICATION = "simple";
    private final Properties config;

    public LdapSearcher(Properties config) {
        this.config = config;
    }

    public LdapResults search(String context, String filterExpr, Object ... filterArgs) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        LdapContext ldapContext = null;
        NamingEnumeration<SearchResult> ldapResult = null;
        try {
            ldapContext = this.buildLdapContext();
            ldapResult = ldapContext.search(context, filterExpr, filterArgs, this.createSearchControls());
            while (ldapResult.hasMore()) {
                searchResults.add(ldapResult.next());
            }
        }
        catch (NamingException ex) {
            throw new RuntimeException("LDAP search has failed", ex);
        }
        finally {
            if (ldapResult != null) {
                try {
                    ldapResult.close();
                }
                catch (NamingException ex) {
                    log.error("Failed to close LDAP results enumeration", (Throwable)ex);
                }
            }
            if (ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException ex) {
                    log.error("Failed to close LDAP context", (Throwable)ex);
                }
            }
        }
        return new LdapResults(searchResults);
    }

    private LdapContext buildLdapContext() throws NamingException {
        this.config.putIfAbsent("java.naming.factory.initial", DEFAULT_INITIAL_CONTEXT_FACTORY);
        this.config.putIfAbsent("java.naming.security.authentication", DEFAULT_SECURITY_AUTHENTICATION);
        String protocol = this.config.getProperty("java.naming.security.protocol");
        this.config.putIfAbsent("java.naming.provider.url", this.createDefaultProviderUrl(protocol));
        if (log.isDebugEnabled()) {
            log.debug("Using following InitialLdapContext properties:");
            log.debug("Initial Context Factory: {}", (Object)this.config.getProperty("java.naming.factory.initial"));
            log.debug("Authentication Type: {}", (Object)this.config.getProperty("java.naming.security.authentication"));
            log.debug("Protocol: {}", (Object)this.config.getProperty("java.naming.security.protocol"));
            log.debug("Provider URL: {}", (Object)this.config.getProperty("java.naming.provider.url"));
            log.debug("User DN: {}", (Object)this.config.getProperty("java.naming.security.principal"));
            log.debug("Password: {}", (Object)this.config.getProperty("java.naming.security.credentials"));
        }
        return new InitialLdapContext(this.config, null);
    }

    private String createDefaultProviderUrl(String protocol) {
        String port = "ssl".equalsIgnoreCase(protocol) ? "636" : "389";
        return "ldap://localhost:" + port;
    }

    private SearchControls createSearchControls() {
        SearchControls searchControls = new SearchControls();
        String searchScope = this.config.getProperty(SEARCH_SCOPE);
        if (searchScope != null) {
            searchControls.setSearchScope(this.parseSearchScope(searchScope));
        }
        return searchControls;
    }

    private int parseSearchScope(String searchScope) {
        log.debug("Search scope: {}", (Object)searchScope);
        try {
            return SearchScope.valueOf(searchScope).ordinal();
        }
        catch (IllegalArgumentException ex) {
            return SearchScope.ONELEVEL_SCOPE.ordinal();
        }
    }

    public class LdapResults {
        private final List<SearchResult> searchResults;

        public LdapResults(List<SearchResult> searchResults) {
            this.searchResults = searchResults;
        }

        public SearchResult getSingleSearchResult() {
            return this.searchResults.isEmpty() ? null : this.searchResults.get(0);
        }

        public List<SearchResult> getSearchResults() {
            return this.searchResults;
        }

        public final String getSingleAttributeResult(String attributeId) {
            List<String> attributeResults = this.getAttributeResults(attributeId);
            return attributeResults.isEmpty() ? null : attributeResults.get(0);
        }

        public final List<String> getAttributeResults(String attributeId) {
            return this.searchResults.stream().map(searchResult -> this.getAttribute((SearchResult)searchResult, attributeId)).collect(Collectors.toList());
        }

        private String getAttribute(SearchResult searchResult, String attributeId) {
            if (searchResult == null) {
                return null;
            }
            Attribute entry = searchResult.getAttributes().get(attributeId);
            if (entry == null) {
                log.warn("The attribute with ID '{}' has not been found.", (Object)attributeId);
                return null;
            }
            try {
                return entry.get().toString();
            }
            catch (NamingException ex) {
                log.error("Failed to get attribute value", (Throwable)ex);
                return null;
            }
        }
    }

    public static enum SearchScope {
        OBJECT_SCOPE,
        ONELEVEL_SCOPE,
        SUBTREE_SCOPE;

    }
}

