/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.jbpm.services.task.identity.AbstractUserGroupInfo;
import org.jbpm.services.task.identity.adapter.UserGroupAdapter;
import org.kie.api.task.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAASUserGroupCallbackImpl
extends AbstractUserGroupInfo
implements UserGroupCallback {
    private static final Logger logger = LoggerFactory.getLogger(JAASUserGroupCallbackImpl.class);
    protected static final String DEFAULT_PROPERTIES_NAME = "classpath:/jbpm.usergroup.callback.properties";
    private ServiceLoader<UserGroupAdapter> ugAdapterServiceLoader = ServiceLoader.load(UserGroupAdapter.class);
    private static final ThreadLocal<UserGroupAdapter> externalUserGroupAdapterLocal = new ThreadLocal();
    private String rolePrincipleName = null;

    public static void addExternalUserGroupAdapter(UserGroupAdapter externalUserGroupAdapter) {
        if (externalUserGroupAdapterLocal.get() != null) {
            UserGroupAdapter adapter = externalUserGroupAdapterLocal.get();
            throw new IllegalStateException("The external UserGroupAdapter has already been set! (" + adapter.getClass().getName() + ")");
        }
        externalUserGroupAdapterLocal.set(externalUserGroupAdapter);
    }

    public static void clearExternalUserGroupAdapter() {
        externalUserGroupAdapterLocal.set(null);
    }

    public JAASUserGroupCallbackImpl(boolean activate) {
        this("Roles");
        String propertiesLocation = System.getProperty("jbpm.usergroup.callback.properties");
        Properties config = this.readProperties(propertiesLocation, DEFAULT_PROPERTIES_NAME);
        if (config != null) {
            this.rolePrincipleName = config.getProperty("jaas.role.principle.name", "Roles");
        }
    }

    public JAASUserGroupCallbackImpl(String rolesPrincipleName) {
        this.rolePrincipleName = rolesPrincipleName;
    }

    public String getRolePrincipleName() {
        return this.rolePrincipleName;
    }

    public void setRolePrincipleName(String rolePrincipleName) {
        this.rolePrincipleName = rolePrincipleName;
    }

    public boolean existsUser(String userId) {
        return true;
    }

    public boolean existsGroup(String groupId) {
        return true;
    }

    public List<String> getGroupsForUser(String userId) {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            UserGroupAdapter adapter;
            Subject subject = this.getSubjectFromContainer();
            if (subject != null && this.subjectContainsUser(subject, userId)) {
                Set<Principal> principals = subject.getPrincipals();
                if (principals != null) {
                    logger.debug("Adding roles from JAAS subject");
                    roles = new ArrayList();
                    for (Principal principal : principals) {
                        if (!(principal instanceof Group) || !this.rolePrincipleName.equalsIgnoreCase(principal.getName())) continue;
                        Enumeration groups = ((Group)principal).members();
                        while (groups.hasMoreElements()) {
                            Principal groupPrincipal = (Principal)groups.nextElement();
                            roles.add(groupPrincipal.getName());
                        }
                        break;
                    }
                }
            } else {
                for (UserGroupAdapter adapter2 : this.ugAdapterServiceLoader) {
                    logger.debug("Adding roles from UserGroupAdapter service ({})", (Object)adapter2.getClass().getSimpleName());
                    List<String> userRoles = adapter2.getGroupsForUser(userId);
                    if (userRoles == null) continue;
                    roles.addAll(userRoles);
                }
            }
            if ((adapter = externalUserGroupAdapterLocal.get()) != null) {
                logger.debug("Adding roles from external UserGroupAdapter ({})", (Object)adapter.getClass().getSimpleName());
                List<String> userRoles = adapter.getGroupsForUser(userId);
                if (userRoles != null) {
                    roles.addAll(userRoles);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error when getting user roles for userid:" + userId, (Throwable)e);
        }
        return roles;
    }

    private boolean subjectContainsUser(Subject subject, String userId) {
        return subject.getPrincipals().stream().map(Principal::getName).anyMatch(userId::equals);
    }

    protected Subject getSubjectFromContainer() {
        try {
            return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (Exception e) {
            return null;
        }
    }
}

