/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment.impl.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.jbpm.services.task.commands.TaskContext;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.assignment.Assignment;
import org.kie.internal.task.api.assignment.AssignmentStrategy;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinAssignmentStrategy
implements AssignmentStrategy {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinAssignmentStrategy.class);
    private static final String IDENTIFIER = "RoundRobin";
    private Map<String, CircularQueue<OrganizationalEntity>> circularQueueMap = new ConcurrentHashMap<String, CircularQueue<OrganizationalEntity>>();

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public Assignment apply(Task task, org.kie.api.task.TaskContext taskContext, String excludedUser) {
        UserInfo userInfo = (UserInfo)((TaskContext)taskContext).get("org.kie.api.task.UserInfo");
        List<OrganizationalEntity> excluded = RoundRobinAssignmentStrategy.getExcludedEntities(task, userInfo);
        List<OrganizationalEntity> potentialOwners = task.getPeopleAssignments().getPotentialOwners().stream().filter(oe -> oe instanceof User && !excluded.contains(oe)).collect(Collectors.toList());
        task.getPeopleAssignments().getPotentialOwners().stream().filter(oe -> oe instanceof Group).forEach(oe -> {
            Iterator groupUsers = userInfo.getMembersForGroup((Group)oe);
            if (groupUsers != null) {
                groupUsers.forEachRemaining(user -> {
                    if (user != null && !excluded.contains(user) && !potentialOwners.contains(user)) {
                        potentialOwners.add((OrganizationalEntity)user);
                    }
                });
            }
        });
        if (excludedUser != null) {
            logger.debug("Removing excluded user {} from the list of eligible users", (Object)excludedUser);
            potentialOwners.removeIf(entity -> entity.getId().equals(excludedUser));
        }
        String queueName = this.getQueueName(task);
        CircularQueue<OrganizationalEntity> mappedQueue = this.synchronizedQueue(queueName, potentialOwners);
        OrganizationalEntity owner = mappedQueue.take();
        return new Assignment(owner.getId());
    }

    private synchronized CircularQueue<OrganizationalEntity> synchronizedQueue(String queueName, List<OrganizationalEntity> potentialOwners) {
        CircularQueue<OrganizationalEntity> existingQueue = queueName == null || queueName.trim().length() == 0 ? null : this.circularQueueMap.get(queueName);
        CircularQueue<OrganizationalEntity> workingQueue = existingQueue != null ? existingQueue : new CircularQueue<OrganizationalEntity>();
        potentialOwners.forEach(po -> {
            if (!this.queueContainsUser(workingQueue, (OrganizationalEntity)po)) {
                workingQueue.add(po);
            }
        });
        workingQueue.removeIf(oe -> !potentialOwners.contains(oe));
        this.circularQueueMap.put(queueName, workingQueue);
        return workingQueue;
    }

    protected boolean queueContainsUser(CircularQueue<OrganizationalEntity> queue, OrganizationalEntity oe) {
        return queue.contains(oe);
    }

    protected String getQueueName(Task task) {
        return task.getTaskData().getProcessId() + "_" + task.getTaskData().getDeploymentId() + "_" + task.getName();
    }

    private static List<OrganizationalEntity> getExcludedEntities(Task task, UserInfo userInfo) {
        List excluded = ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners();
        ArrayList excludedUsers = new ArrayList();
        for (OrganizationalEntity entity : excluded) {
            if (!(entity instanceof Group)) continue;
            userInfo.getMembersForGroup((Group)entity).forEachRemaining(excludedUsers::add);
        }
        excluded.addAll(excludedUsers);
        return excluded;
    }

    private class CircularQueue<T>
    extends LinkedBlockingQueue<T> {
        private CircularQueue() {
        }

        @Override
        public synchronized T take() {
            T headValue = null;
            try {
                headValue = (T)super.take();
                super.offer(headValue);
            }
            catch (InterruptedException e) {
                logger.error("Thread interrupted during the 'take' from a circular queue in the RoundRobinAssignmentStrategy", (Throwable)e);
            }
            return headValue;
        }
    }
}

