/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.util;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.impl.util.HumanTaskHandlerHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.InternalTask;

public class DeadlineSchedulerHelper {
    public static void rescheduleDeadlinesForTask(InternalTask task, TaskContext taskContext, TaskDeadlinesService.DeadlineType ... types) {
        Environment environment = taskContext.getTaskContentService().getMarshallerContext((Task)task).getEnvironment();
        TaskPersistenceContext persistenceContext = taskContext.getPersistenceContext();
        taskContext.loadTaskVariables((Task)task);
        PeopleAssignments peopleAssignments = task.getPeopleAssignments();
        List businessAdministrators = peopleAssignments.getBusinessAdministrators();
        List<TaskDeadlinesService.DeadlineType> deadlineTypes = Arrays.asList(types);
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines(task.getTaskData().getTaskInputVariables(), businessAdministrators, environment);
        if (deadlineTypes.contains(TaskDeadlinesService.DeadlineType.START)) {
            for (Deadline deadline : deadlines.getStartDeadlines()) {
                task.getDeadlines().getStartDeadlines().add(deadline);
                persistenceContext.persistDeadline(deadline);
            }
        }
        if (deadlineTypes.contains(TaskDeadlinesService.DeadlineType.END)) {
            for (Deadline deadline : deadlines.getEndDeadlines()) {
                task.getDeadlines().getEndDeadlines().add(deadline);
                persistenceContext.persistDeadline(deadline);
            }
        }
        persistenceContext.updateTask((Task)task);
        DeadlineSchedulerHelper.scheduleDeadlinesForTask(task, taskContext, types);
    }

    public static void scheduleDeadlinesForTask(InternalTask task, TaskContext taskContext, TaskDeadlinesService.DeadlineType ... types) {
        TaskDeadlinesService deadlineService = taskContext.getTaskDeadlinesService();
        long now = System.currentTimeMillis();
        List<TaskDeadlinesService.DeadlineType> deadlineTypes = Arrays.asList(types);
        Deadlines deadlines = task.getDeadlines();
        if (deadlines != null) {
            List endDeadlines;
            List startDeadlines = deadlines.getStartDeadlines();
            if (startDeadlines != null && deadlineTypes.contains(TaskDeadlinesService.DeadlineType.START)) {
                DeadlineSchedulerHelper.scheduleDeadlines(startDeadlines, now, task.getId(), TaskDeadlinesService.DeadlineType.START, deadlineService);
            }
            if ((endDeadlines = deadlines.getEndDeadlines()) != null && deadlineTypes.contains(TaskDeadlinesService.DeadlineType.END)) {
                DeadlineSchedulerHelper.scheduleDeadlines(endDeadlines, now, task.getId(), TaskDeadlinesService.DeadlineType.END, deadlineService);
            }
        }
    }

    public static void scheduleDeadlines(List<? extends Deadline> deadlines, long now, long taskId, TaskDeadlinesService.DeadlineType type, TaskDeadlinesService deadlineService) {
        for (Deadline deadline : deadlines) {
            if (deadline.isEscalated().booleanValue()) continue;
            Date date = deadline.getDate();
            deadlineService.schedule(taskId, deadline.getId(), date.getTime() - now, type);
        }
    }
}

