/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.command.ProcessInstanceIdCommand;

@XmlRootElement(name="get-completed-tasks-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetCompletedTasksCommand
extends TaskCommand<List<TaskSummary>>
implements ProcessInstanceIdCommand {
    private static final long serialVersionUID = 5077599352603072633L;
    @XmlElement
    private Date date;
    @XmlElement(name="process-instance-id")
    @XmlSchemaType(name="long")
    private Long processInstanceId;

    public GetCompletedTasksCommand() {
    }

    public GetCompletedTasksCommand(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public GetCompletedTasksCommand(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public List<TaskSummary> execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        if (this.date != null) {
            return context.getTaskAdminService().getCompletedTasks(this.date);
        }
        if (this.processInstanceId != null) {
            return context.getTaskAdminService().getCompletedTasksByProcessId(this.processInstanceId);
        }
        return context.getTaskAdminService().getCompletedTasks();
    }
}

