/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import org.drools.core.command.CommandService;
import org.drools.core.command.Interceptor;
import org.drools.core.command.impl.GenericCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.TaskEventSupport;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.kie.internal.command.Context;

public class TaskCommandExecutorImpl
implements CommandService {
    private Environment environment;
    private TaskEventSupport taskEventSupport;
    private CommandService commandService = new SelfExecutionCommandService(this);

    public TaskCommandExecutorImpl(Environment environment, TaskEventSupport taskEventSupport) {
        this.environment = environment;
        this.taskEventSupport = taskEventSupport;
    }

    public <T> T execute(Command<T> command) {
        return (T)this.commandService.execute(command);
    }

    public void addInterceptor(Interceptor interceptor) {
        interceptor.setNext(this.commandService);
        this.commandService = interceptor;
    }

    public Context getContext() {
        if (this.commandService instanceof SelfExecutionCommandService) {
            return new TaskContext();
        }
        return new TaskContext(this.commandService.getContext(), this.environment, this.taskEventSupport);
    }

    private class SelfExecutionCommandService
    implements CommandService {
        private TaskCommandExecutorImpl owner;

        SelfExecutionCommandService(TaskCommandExecutorImpl owner) {
            this.owner = owner;
        }

        public <T> T execute(Command<T> command) {
            if (command instanceof TaskCommand) {
                return (T)((GenericCommand)command).execute(this.getContext());
            }
            throw new IllegalArgumentException("Task service can only execute task commands");
        }

        public Context getContext() {
            return this.owner.getContext();
        }
    }
}

