/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import org.drools.persistence.TransactionManager;
import org.jbpm.task.service.persistence.TaskTransactionManager;

class TaskSpringTransactionManager
implements TaskTransactionManager {
    public static final int STATUS_ROLLBACK_ONLY = 5;
    private static volatile AtomicInteger idGenerator = new AtomicInteger(0);
    private int id = idGenerator.incrementAndGet();
    private AtomicInteger l = new AtomicInteger(0);
    private TransactionManager tm;
    private boolean useJTA;
    private static final boolean debug = false;

    TaskSpringTransactionManager(TransactionManager springTransactionManager, boolean useJTA) {
        this.tm = springTransactionManager;
        this.useJTA = useJTA;
    }

    public void attachPersistenceContext(EntityManager em) {
        if (this.useJTA) {
            em.joinTransaction();
        }
    }

    public boolean begin(EntityManager em) {
        boolean owner = this.tm.begin();
        return owner;
    }

    public void commit(EntityManager em, boolean txOwner) {
        this.tm.commit(txOwner);
    }

    public void rollback(EntityManager em, boolean txOwner) {
        int status = this.tm.getStatus();
        switch (status) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                this.tm.rollback(txOwner);
                break;
            }
            default: {
                throw new RuntimeException("Unknown transaction state when rolling back.");
            }
        }
    }

    public int getStatus(EntityManager em) {
        return this.tm.getStatus();
    }

    public void dispose() {
        int status = this.tm.getStatus();
        if (status == 4) {
            try {
                this.tm.commit(true);
            }
            catch (RuntimeException t) {}
        } else if (status == 5) {
            try {
                this.tm.rollback(true);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.tm = null;
    }

    private void debug(String op, boolean plus, boolean owner) {
    }

    private void debugNested(String op, boolean plus) {
        int lvl = this.l.get();
        lvl = plus ? this.l.incrementAndGet() : this.l.getAndDecrement();
        System.out.println(this.id + " [" + op + "] " + lvl);
    }

    private void debugEmfGenerated(String op, boolean plus, boolean owner) {
        int lvl = this.l.get();
        if (owner) {
            lvl = plus ? this.l.incrementAndGet() : this.l.getAndDecrement();
        }
        System.out.println(this.id + " [" + op + "] " + lvl + " " + (owner ? "" : "-"));
    }
}

