/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jbpm.task.Group;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.query.DeadlineSummary;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.persistence.TaskLocalTransactionManager;
import org.jbpm.task.service.persistence.TaskTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPersistenceManager {
    private static Logger logger = LoggerFactory.getLogger(TaskPersistenceManager.class);
    private TaskTransactionManager ttxm;
    private EntityManager em;

    TaskPersistenceManager(EntityManager em) {
        this.em = em;
        this.ttxm = new TaskLocalTransactionManager();
    }

    TaskPersistenceManager(EntityManager entityManager, TaskTransactionManager ttxm) {
        this.em = entityManager;
        this.ttxm = ttxm;
    }

    public boolean beginTransaction() {
        boolean txOwner = this.ttxm.begin(this.em);
        this.ttxm.attachPersistenceContext(this.em);
        return txOwner;
    }

    public void endTransaction(boolean txOwner) {
        try {
            this.ttxm.commit(this.em, txOwner);
        }
        catch (RuntimeException re) {
            logger.error("Unable to commit, rolling back transaction.", (Throwable)re);
            this.ttxm.rollback(this.em, txOwner);
            throw re;
        }
    }

    public void rollBackTransaction(boolean txOwner) {
        try {
            this.ttxm.rollback(this.em, txOwner);
        }
        catch (RuntimeException re) {
            logger.error("Unable to rollback transaction (or to mark as 'to rollback')!", (Throwable)re);
        }
    }

    public void dispose() {
        this.endPersistenceContext();
    }

    public void endPersistenceContext() {
        if (this.em == null) {
            this.ttxm = null;
            return;
        }
        boolean closeEm = this.em.isOpen();
        if (closeEm) {
            try {
                this.ttxm.dispose();
                this.em.clear();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.em.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.em = null;
        this.ttxm = null;
    }

    public List<DeadlineSummary> getUnescalatedDeadlines() {
        boolean txOwner = this.beginTransaction();
        List<DeadlineSummary> resultList = this.getUnescalatedDeadlinesList();
        this.endTransaction(txOwner);
        return resultList;
    }

    public void setTaskStatusInTransaction(Object taskId, Status taskStatus) {
        boolean txOwner = this.beginTransaction();
        Task task = (Task)this.em.find(Task.class, taskId);
        task.getTaskData().setStatus(Status.Completed);
        this.em.persist((Object)task);
        this.endTransaction(txOwner);
    }

    public List<DeadlineSummary> getUnescalatedDeadlinesList() {
        return this.em.createNamedQuery("UnescalatedDeadlines").getResultList();
    }

    public Object findEntity(Class<?> entityClass, Object primaryKey) {
        return this.em.find(entityClass, primaryKey);
    }

    public void deleteEntity(Object entity) {
        this.em.remove(entity);
    }

    public void saveEntity(Object entity) {
        this.em.persist(entity);
    }

    public Query createQuery(String queryName) {
        return this.em.createNamedQuery(queryName);
    }

    public Query createNewQuery(String queryString) {
        return this.em.createQuery(queryString);
    }

    public boolean userExists(String userId) {
        return this.em.find(User.class, (Object)userId) != null;
    }

    public boolean groupExists(String groupId) {
        return this.em.find(Group.class, (Object)groupId) != null;
    }

    public List<TaskSummary> queryTasksWithUserIdAndLanguage(String queryName, String userId, String language) {
        Query query = this.createQuery(queryName);
        query.setParameter("userId", (Object)userId);
        query.setParameter("language", (Object)language);
        List resultListObject = query.getResultList();
        return resultListObject;
    }

    public List<TaskSummary> queryTasksWithUserIdStatusAndLanguage(String queryName, String userId, List<Status> status, String language) {
        Query query = this.createQuery(queryName);
        query.setParameter("userId", (Object)userId);
        query.setParameter("status", status);
        query.setParameter("language", (Object)language);
        List resultListObject = query.getResultList();
        return resultListObject;
    }
}

