/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.process.workitem.wsht.AbstractHTWorkItemHandler;
import org.jbpm.process.workitem.wsht.GenericHTWorkItemHandler;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.TaskFailedEvent;
import org.jbpm.task.event.TaskSkippedEvent;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;
import org.jbpm.task.utils.ContentMarshallerContext;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.jbpm.task.utils.OnErrorAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncGenericHTWorkItemHandler
extends AbstractHTWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(GenericHTWorkItemHandler.class);
    private AsyncTaskService client;
    private String ipAddress;
    private int port;
    private WorkItemManager manager;
    private boolean local = false;
    private boolean connected = false;

    public AsyncGenericHTWorkItemHandler(KnowledgeRuntime session, OnErrorAction action) {
        super(session, action);
    }

    public AsyncGenericHTWorkItemHandler(KnowledgeRuntime session) {
        super(session);
    }

    public AsyncTaskService getClient() {
        return this.client;
    }

    public void setClient(AsyncTaskService client) {
        this.client = client;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getPort() {
        return this.port;
    }

    private void registerTaskEvents() {
        TaskCompletedHandler eventResponseHandler = new TaskCompletedHandler(this.manager, this.marshallerContext, this.session.getEnvironment(), this.client);
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskFailedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskSkippedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
    }

    public void connect() {
        if (this.client == null) {
            throw new IllegalStateException("You must set the Task Service Client to the work item to work");
        }
        if (this.ipAddress == null || this.ipAddress.equals("") || this.port <= 0) {
            throw new IllegalStateException("You must set the IP and Port to the work item to work");
        }
        if (this.client != null) {
            if (!this.connected) {
                this.connected = this.client.connect(this.ipAddress, this.port);
                if (!this.connected) {
                    throw new IllegalArgumentException("Could not connect task client");
                }
                this.registerTaskEvents();
            } else {
                logger.warn(" Task Service Client was already connected, just saying ... ");
            }
        }
    }

    public void dispose() throws Exception {
        for (TaskEventKey key : this.eventHandlers.keySet()) {
            this.client.registerForEvent(key, true, (EventResponseHandler)this.eventHandlers.get(key));
        }
        this.eventHandlers.clear();
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.manager = manager;
        Task task = this.createTaskBasedOnWorkItemParams(workItem);
        ContentData content = this.createTaskContentBasedOnWorkItemParams(workItem);
        this.connect();
        this.client.addTask(task, content, new TaskAddedHandler(workItem.getId()));
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        AbortTaskResponseHandler abortTaskResponseHandler = new AbortTaskResponseHandler(this.client);
        this.client.getTaskByWorkItemId(workItem.getId(), abortTaskResponseHandler);
    }

    private static class AbortTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private AsyncTaskService client;

        public AbortTaskResponseHandler(AsyncTaskService client) {
            this.client = client;
        }

        public void execute(Task task) {
            if (task != null) {
                this.client.exit(task.getId(), "Administrator", null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetResultContentResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetContentResponseHandler {
        private WorkItemManager manager;
        private Task task;
        private Map<String, Object> results;
        private ContentMarshallerContext marshallContext;
        private Environment env;

        public GetResultContentResponseHandler(WorkItemManager manager, ContentMarshallerContext marshallContext, Environment env, Task task, Map<String, Object> results) {
            this.manager = manager;
            this.task = task;
            this.results = results;
            this.marshallContext = marshallContext;
            this.env = env;
        }

        @Override
        public void execute(Content content) {
            Object result = ContentMarshallerHelper.unmarshall(this.task.getTaskData().getDocumentType(), content.getContent(), this.marshallContext, this.env);
            this.results.put("Result", result);
            if (result instanceof Map) {
                Map map = (Map)result;
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    this.results.put((String)entry.getKey(), entry.getValue());
                }
            }
            this.manager.completeWorkItem(this.task.getTaskData().getWorkItemId(), this.results);
        }
    }

    private static class GetCompletedTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private WorkItemManager manager;
        private AsyncTaskService client;
        private ContentMarshallerContext marshallContext;
        private Environment env;

        public GetCompletedTaskResponseHandler(WorkItemManager manager, ContentMarshallerContext marshallContext, Environment env, AsyncTaskService client) {
            this.manager = manager;
            this.client = client;
            this.marshallContext = marshallContext;
            this.env = env;
        }

        public void execute(Task task) {
            long workItemId = task.getTaskData().getWorkItemId();
            if (task.getTaskData().getStatus() == Status.Completed) {
                String userId = task.getTaskData().getActualOwner().getId();
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("ActorId", userId);
                long contentId = task.getTaskData().getOutputContentId();
                if (contentId != -1L) {
                    GetResultContentResponseHandler getContentResponseHandler = new GetResultContentResponseHandler(this.manager, this.marshallContext, this.env, task, results);
                    this.client.getContent(contentId, getContentResponseHandler);
                } else {
                    this.manager.completeWorkItem(workItemId, results);
                }
            } else {
                this.manager.abortWorkItem(workItemId);
            }
        }
    }

    private static class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private WorkItemManager manager;
        private AsyncTaskService client;
        private ContentMarshallerContext marshallContext;
        private Environment env;

        public TaskCompletedHandler(WorkItemManager manager, ContentMarshallerContext marshallContext, Environment env, AsyncTaskService client) {
            this.manager = manager;
            this.client = client;
            this.marshallContext = marshallContext;
            this.env = env;
        }

        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            long taskId = event.getTaskId();
            GetCompletedTaskResponseHandler getTaskResponseHandler = new GetCompletedTaskResponseHandler(this.manager, this.marshallContext, this.env, this.client);
            this.client.getTask(taskId, getTaskResponseHandler);
        }

        public boolean isRemove() {
            return false;
        }
    }

    private class TaskAddedHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.AddTaskResponseHandler {
        private long workItemId;

        public TaskAddedHandler(long workItemId) {
            this.workItemId = workItemId;
        }

        public void execute(long taskId) {
        }

        public synchronized void setError(RuntimeException error) {
            super.setError(error);
            if (AsyncGenericHTWorkItemHandler.this.action.equals((Object)OnErrorAction.ABORT)) {
                AsyncGenericHTWorkItemHandler.this.manager.abortWorkItem(this.workItemId);
            } else {
                if (AsyncGenericHTWorkItemHandler.this.action.equals((Object)OnErrorAction.RETHROW)) {
                    throw this.getError();
                }
                if (AsyncGenericHTWorkItemHandler.this.action.equals((Object)OnErrorAction.LOG)) {
                    StringBuffer logMsg = new StringBuffer();
                    logMsg.append(new Date() + ": Error when creating task on task server for work item id " + this.workItemId);
                    logMsg.append(". Error reported by task server: " + this.getError().getMessage());
                    logger.error(logMsg.toString(), (Throwable)this.getError());
                }
            }
        }
    }
}

