/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.bpmn2.xml.AbstractCompositeNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.xml.sax.Attributes;

public class CompositeContextNodeHandler
extends AbstractCompositeNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        throw new IllegalArgumentException("Reading in should be handled by end event handler");
    }

    public Class generateNodeFor() {
        return CompositeContextNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        Object isForCompensationObject;
        CompositeContextNode compositeNode = (CompositeContextNode)node;
        String nodeType = "subProcess";
        if (node.getMetaData().get("Transaction") != null) {
            nodeType = "transaction";
        }
        this.writeNode(nodeType, (Node)compositeNode, xmlDump, metaDataType);
        if (compositeNode instanceof EventSubProcessNode) {
            xmlDump.append(" triggeredByEvent=\"true\" ");
        }
        if ((isForCompensationObject = compositeNode.getMetaData("isForCompensation")) != null && ((Boolean)isForCompensationObject).booleanValue()) {
            xmlDump.append("isForCompensation=\"true\" ");
        }
        xmlDump.append(">" + EOL);
        this.writeExtensionElements((Node)compositeNode, xmlDump);
        VariableScope variableScope = (VariableScope)compositeNode.getDefaultContext("VariableScope");
        if (variableScope != null && !variableScope.getVariables().isEmpty()) {
            xmlDump.append("    <!-- variables -->" + EOL);
            for (Variable variable : variableScope.getVariables()) {
                xmlDump.append("    <property id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "\" ");
                if (variable.getType() != null) {
                    xmlDump.append("itemSubjectRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)compositeNode) + "-" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "Item\"");
                }
                xmlDump.append("/>" + EOL);
            }
        }
        List<Node> subNodes = this.getSubNodes((CompositeNode)compositeNode);
        XmlBPMNProcessDumper.INSTANCE.visitNodes(subNodes, xmlDump, metaDataType);
        this.visitConnectionsAndAssociations((Node)compositeNode, xmlDump, metaDataType);
        this.endNode(nodeType, xmlDump);
    }

    protected List<Node> getSubNodes(CompositeNode compositeNode) {
        ArrayList<Node> subNodes = new ArrayList<Node>();
        for (org.kie.api.definition.process.Node subNode : compositeNode.getNodes()) {
            if (subNode instanceof CompositeNode.CompositeNodeStart || subNode instanceof CompositeNode.CompositeNodeEnd) continue;
            subNodes.add((Node)subNode);
        }
        return subNodes;
    }
}

