/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.VariableResolver;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.impl.JavaAction;
import org.jbpm.process.instance.impl.util.VariableUtil;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;

public class SendSignalAction
implements JavaAction {
    private static final long serialVersionUID = 1L;
    private String signalName;
    private String varName;
    private boolean isAsync;
    private NodeImpl node;

    public SendSignalAction(NodeImpl node, String variable, String signalName, boolean isAsync) {
        this.node = node;
        this.varName = variable;
        this.signalName = signalName;
        this.isAsync = isAsync;
    }

    public void execute(ProcessContext kcontext) throws Exception {
        Object tVariable = VariableResolver.getVariable(kcontext, this.varName);
        ((InternalProcessRuntime)((InternalKnowledgeRuntime)kcontext.getKieRuntime()).getProcessRuntime()).getProcessEventSupport().fireOnSignal(kcontext.getProcessInstance(), kcontext.getNodeInstance(), kcontext.getKieRuntime(), this.signalName, tVariable);
        String scope = (String)this.node.getMetaData("customScope");
        String signalType = VariableUtil.resolveVariable((String)(this.isAsync ? "ASYNC-" + this.signalName : this.signalName), (NodeInstance)kcontext.getNodeInstance());
        if ("processInstance".equalsIgnoreCase(scope)) {
            kcontext.getProcessInstance().signalEvent(signalType, tVariable);
        } else if ("runtimeManager".equalsIgnoreCase(scope) || "project".equalsIgnoreCase(scope)) {
            ((RuntimeManager)kcontext.getKieRuntime().getEnvironment().get("RuntimeManager")).signalEvent(signalType, tVariable);
        } else if ("external".equalsIgnoreCase(scope)) {
            WorkItemImpl workItem = new WorkItemImpl();
            workItem.setName("External Send Task");
            workItem.setNodeInstanceId(kcontext.getNodeInstance().getId());
            workItem.setProcessInstanceId(kcontext.getProcessInstance().getId());
            workItem.setNodeId(kcontext.getNodeInstance().getNodeId());
            workItem.setDeploymentId((String)kcontext.getKieRuntime().getEnvironment().get("deploymentId"));
            workItem.setParameter("Signal", (Object)signalType);
            workItem.setParameter("SignalProcessInstanceId", kcontext.getVariable("SignalProcessInstanceId"));
            workItem.setParameter("SignalWorkItemId", kcontext.getVariable("SignalWorkItemId"));
            workItem.setParameter("SignalDeploymentId", kcontext.getVariable("SignalDeploymentId"));
            if (tVariable != null) {
                workItem.setParameter("Data", tVariable);
            }
            ((WorkItemManager)kcontext.getKieRuntime().getWorkItemManager()).internalExecuteWorkItem((WorkItem)workItem);
        } else {
            kcontext.getKieRuntime().signalEvent(signalType, tVariable);
        }
    }

    public String getVariable() {
        return this.varName;
    }

    public String getSignalName() {
        return this.signalName;
    }
}

