/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Connection;
import org.xnio.XnioIoThread;
import org.xnio._private.Messages;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public abstract class StreamConnection
extends Connection
implements CloseListenerSettable<StreamConnection> {
    private ConduitStreamSourceChannel sourceChannel;
    private ConduitStreamSinkChannel sinkChannel;
    private ChannelListener<? super StreamConnection> closeListener;

    protected StreamConnection(XnioIoThread thread) {
        super(thread);
    }

    @Override
    protected void notifyReadClosed() {
        try {
            this.getSourceChannel().shutdownReads();
        }
        catch (IOException e) {
            Messages.msg.connectionNotifyReadClosedFailed(e, this);
        }
    }

    @Override
    protected void notifyWriteClosed() {
        try {
            this.getSinkChannel().shutdownWrites();
        }
        catch (IOException e) {
            Messages.msg.connectionNotifyWriteClosedFailed(e, this);
        }
    }

    @Override
    public void setCloseListener(ChannelListener<? super StreamConnection> listener) {
        this.closeListener = listener;
    }

    @Override
    public ChannelListener<? super StreamConnection> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<? extends StreamConnection> getCloseSetter() {
        return new CloseListenerSettable.Setter<StreamConnection>(this);
    }

    protected void setSourceConduit(StreamSourceConduit conduit) {
        this.sourceChannel = conduit == null ? null : new ConduitStreamSourceChannel(this, conduit);
    }

    protected void setSinkConduit(StreamSinkConduit conduit) {
        this.sinkChannel = conduit == null ? null : new ConduitStreamSinkChannel(this, conduit);
    }

    @Override
    void invokeCloseListener() {
        ChannelListeners.invokeChannelListener(this, this.closeListener);
    }

    private static <T> T notNull(T orig) throws IllegalStateException {
        if (orig == null) {
            throw Messages.msg.channelNotAvailable();
        }
        return orig;
    }

    public ConduitStreamSourceChannel getSourceChannel() {
        return StreamConnection.notNull(this.sourceChannel);
    }

    public ConduitStreamSinkChannel getSinkChannel() {
        return StreamConnection.notNull(this.sinkChannel);
    }
}

