/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.wildfly.common.Assert;
import org.wildfly.common.cpu.CacheInfo;
import org.xnio.Buffers;

public abstract class ByteBufferPool {
    private static final boolean sliceLargeBuffers = Boolean.parseBoolean(System.getProperty("xnio.buffer.slice-large-buffers", "true"));
    private final ConcurrentLinkedQueue<ByteBuffer> masterQueue = new ConcurrentLinkedQueue();
    private final LocalBufferCacheThreadLocal threadLocal = new LocalBufferCacheThreadLocal(this);
    private final int size;
    private final boolean direct;
    public static final int LARGE_SIZE = 0x100000;
    public static final int MEDIUM_SIZE = 8192;
    public static final int SMALL_SIZE = 64;
    static final int LOCAL_QUEUE_SIZE = 16;
    static final int CACHE_LINE_SIZE = Math.max(64, CacheInfo.getSmallestDataCacheLineSize());
    public static final ByteBufferPool LARGE_DIRECT = ByteBufferPool.create(0x100000, true);
    public static final ByteBufferPool MEDIUM_DIRECT = sliceLargeBuffers ? ByteBufferPool.subPool(LARGE_DIRECT, 8192) : ByteBufferPool.create(8192, true);
    public static final ByteBufferPool SMALL_DIRECT = ByteBufferPool.subPool(MEDIUM_DIRECT, 64);
    public static final ByteBufferPool LARGE_HEAP = ByteBufferPool.create(0x100000, false);
    public static final ByteBufferPool MEDIUM_HEAP = ByteBufferPool.create(8192, false);
    public static final ByteBufferPool SMALL_HEAP = ByteBufferPool.create(64, false);

    ByteBufferPool(int size, boolean direct) {
        assert (Integer.bitCount(size) == 1);
        assert (size >= 16);
        assert (size <= 0x40000000);
        this.size = size;
        this.direct = direct;
    }

    public ByteBuffer allocate() {
        LocalBufferCache localCache = (LocalBufferCache)this.threadLocal.get();
        ByteBuffer byteBuffer = localCache.queue.pollLast();
        if (byteBuffer == null) {
            ConcurrentLinkedQueue<ByteBuffer> masterQueue = this.masterQueue;
            byteBuffer = masterQueue.poll();
            if (byteBuffer == null) {
                byteBuffer = this.createBuffer();
            } else {
                ++localCache.outstanding;
            }
        }
        return byteBuffer;
    }

    public void allocate(ByteBuffer[] array, int offs) {
        this.allocate(array, offs, array.length - offs);
    }

    public void allocate(ByteBuffer[] array, int offs, int len) {
        Assert.checkNotNullParam((String)"array", (Object)array);
        Assert.checkArrayBounds((Object[])array, (int)offs, (int)len);
        LocalBufferCache localCache = (LocalBufferCache)this.threadLocal.get();
        int outstanding = localCache.outstanding;
        ArrayDeque<ByteBuffer> queue = localCache.queue;
        for (int i = 0; i < len; ++i) {
            ByteBuffer byteBuffer = queue.pollLast();
            if (byteBuffer == null) {
                ConcurrentLinkedQueue<ByteBuffer> masterQueue = this.masterQueue;
                byteBuffer = masterQueue.poll();
                if (byteBuffer == null) {
                    byteBuffer = this.createBuffer();
                } else {
                    ++outstanding;
                }
            }
            array[offs + i] = byteBuffer;
        }
        localCache.outstanding = outstanding;
    }

    public static void free(ByteBuffer buffer) {
        Assert.checkNotNullParam((String)"buffer", (Object)buffer);
        int size = buffer.capacity();
        if (Integer.bitCount(size) == 1 && !buffer.isReadOnly()) {
            if (buffer.isDirect()) {
                if (!(buffer instanceof MappedByteBuffer)) {
                    if (size == 8192) {
                        MEDIUM_DIRECT.doFree(buffer);
                    } else if (size == 64) {
                        SMALL_DIRECT.doFree(buffer);
                    } else if (size == 0x100000) {
                        LARGE_DIRECT.doFree(buffer);
                    }
                }
            } else if (size == 8192) {
                MEDIUM_HEAP.doFree(buffer);
            } else if (size == 64) {
                SMALL_HEAP.doFree(buffer);
            } else if (size == 0x100000) {
                LARGE_HEAP.doFree(buffer);
            }
        }
    }

    public static void free(ByteBuffer[] array, int offs, int len) {
        Assert.checkArrayBounds((Object[])array, (int)offs, (int)len);
        for (int i = 0; i < len; ++i) {
            ByteBuffer buffer = array[offs + i];
            if (buffer == null) continue;
            int size = buffer.capacity();
            if (Integer.bitCount(size) == 1 && !buffer.isReadOnly()) {
                if (buffer.isDirect()) {
                    if (!(buffer instanceof MappedByteBuffer)) {
                        if (size == 8192) {
                            MEDIUM_DIRECT.doFree(buffer);
                        } else if (size == 64) {
                            SMALL_DIRECT.doFree(buffer);
                        } else if (size == 0x100000) {
                            LARGE_DIRECT.doFree(buffer);
                        }
                    }
                } else if (size == 8192) {
                    MEDIUM_HEAP.doFree(buffer);
                } else if (size == 64) {
                    SMALL_HEAP.doFree(buffer);
                } else if (size == 0x100000) {
                    LARGE_HEAP.doFree(buffer);
                }
            }
            array[offs + i] = null;
        }
    }

    public static void zeroAndFree(ByteBuffer buffer) {
        Buffers.zero(buffer);
        ByteBufferPool.free(buffer);
    }

    public boolean isDirect() {
        return this.direct;
    }

    public int getSize() {
        return this.size;
    }

    static ByteBufferPool create(int size, boolean direct) {
        assert (Integer.bitCount(size) == 1);
        assert (size >= 16);
        assert (size <= 0x40000000);
        return new ByteBufferPool(size, direct){

            @Override
            ByteBuffer createBuffer() {
                return this.isDirect() ? ByteBuffer.allocateDirect(this.getSize()) : ByteBuffer.allocate(this.getSize());
            }
        };
    }

    static ByteBufferPool subPool(final ByteBufferPool parent, int size) {
        assert (Integer.bitCount(size) == 1);
        assert (Integer.bitCount(parent.getSize()) == 1);
        assert (size >= 16);
        assert (size < parent.getSize());
        assert (parent.getSize() % size == 0);
        return new ByteBufferPool(size, parent.isDirect()){

            @Override
            ByteBuffer createBuffer() {
                ByteBuffer parentBuffer = parent.allocate();
                int size = this.getSize();
                ByteBuffer result = Buffers.slice(parentBuffer, size);
                while (parentBuffer.hasRemaining()) {
                    if (size < CACHE_LINE_SIZE) {
                        Buffers.skip(parentBuffer, CACHE_LINE_SIZE - size);
                    }
                    super.doFree(Buffers.slice(parentBuffer, size));
                }
                return result;
            }
        };
    }

    abstract ByteBuffer createBuffer();

    final void doFree(ByteBuffer buffer) {
        assert (buffer.capacity() == this.size);
        assert (buffer.isDirect() == this.direct);
        buffer.clear();
        LocalBufferCache localCache = (LocalBufferCache)this.threadLocal.get();
        int oldVal = localCache.outstanding;
        if (oldVal >= 16 || localCache.queue.size() == 16) {
            this.masterQueue.add(buffer);
        } else {
            localCache.outstanding = oldVal - 1;
            localCache.queue.add(buffer);
        }
    }

    ConcurrentLinkedQueue<ByteBuffer> getMasterQueue() {
        return this.masterQueue;
    }

    LocalBufferCacheThreadLocal getThreadLocal() {
        return this.threadLocal;
    }

    static class LocalBufferCache {
        final LocalBufferCacheThreadLocal bufferQueue;
        final ArrayDeque<ByteBuffer> queue = new ArrayDeque(16);
        int outstanding;

        LocalBufferCache(ByteBufferPool byteBufferPool) {
            this.bufferQueue = byteBufferPool.getThreadLocal();
        }

        protected void finalize() throws Throwable {
            this.empty();
        }

        void empty() {
            ArrayDeque<ByteBuffer> queue = this.queue;
            if (!queue.isEmpty()) {
                ConcurrentLinkedQueue<ByteBuffer> masterQueue = this.bufferQueue.byteBufferPool.getMasterQueue();
                do {
                    masterQueue.add(queue.poll());
                } while (!queue.isEmpty());
            }
        }
    }

    static class LocalBufferCacheThreadLocal
    extends ThreadLocal<LocalBufferCache> {
        final ByteBufferPool byteBufferPool;

        LocalBufferCacheThreadLocal(ByteBufferPool byteBufferPool) {
            this.byteBufferPool = byteBufferPool;
        }

        @Override
        protected LocalBufferCache initialValue() {
            return new LocalBufferCache(this.byteBufferPool);
        }

        @Override
        public void remove() {
            ((LocalBufferCache)this.get()).empty();
        }
    }

    public static final class Set {
        private final ByteBufferPool small;
        private final ByteBufferPool normal;
        private final ByteBufferPool large;
        public static final Set DIRECT = new Set(SMALL_DIRECT, MEDIUM_DIRECT, LARGE_DIRECT);
        public static final Set HEAP = new Set(SMALL_HEAP, MEDIUM_HEAP, LARGE_HEAP);

        Set(ByteBufferPool small, ByteBufferPool normal, ByteBufferPool large) {
            this.small = small;
            this.normal = normal;
            this.large = large;
        }

        public ByteBufferPool getSmall() {
            return this.small;
        }

        public ByteBufferPool getNormal() {
            return this.normal;
        }

        public ByteBufferPool getLarge() {
            return this.large;
        }
    }
}

