/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSourceChannel;

public class BlockingReadableByteChannel
implements ScatteringByteChannel {
    private final StreamSourceChannel delegate;
    private volatile long readTimeout;

    public BlockingReadableByteChannel(StreamSourceChannel delegate) {
        this.delegate = delegate;
    }

    public BlockingReadableByteChannel(StreamSourceChannel delegate, long readTimeout, TimeUnit readTimeoutUnit) {
        if (readTimeout < 0L) {
            throw new IllegalArgumentException("Negative read timeout");
        }
        this.delegate = delegate;
        long calcTimeout = readTimeoutUnit.toNanos(readTimeout);
        this.readTimeout = readTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    public void setReadTimeout(long readTimeout, TimeUnit readTimeoutUnit) {
        if (readTimeout < 0L) {
            throw new IllegalArgumentException("Negative read timeout");
        }
        long calcTimeout = readTimeoutUnit.toNanos(readTimeout);
        this.readTimeout = readTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (!Buffers.hasRemaining(dsts, offset, length)) {
            return 0L;
        }
        StreamSourceChannel delegate = this.delegate;
        long res = delegate.read(dsts, offset, length);
        if (res == 0L) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long readTimeout;
                if ((readTimeout = this.readTimeout) == 0L || readTimeout == Long.MAX_VALUE) {
                    delegate.awaitReadable();
                } else {
                    if (readTimeout <= elapsed) {
                        throw new ReadTimeoutException("Read timed out");
                    }
                    delegate.awaitReadable(readTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while ((res = delegate.read(dsts, offset, length)) == 0L);
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!dst.hasRemaining()) {
            return 0;
        }
        StreamSourceChannel delegate = this.delegate;
        int res = delegate.read(dst);
        if (res == 0) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long readTimeout;
                if ((readTimeout = this.readTimeout) == 0L || readTimeout == Long.MAX_VALUE) {
                    delegate.awaitReadable();
                } else {
                    if (readTimeout <= elapsed) {
                        throw new ReadTimeoutException("Read timed out");
                    }
                    delegate.awaitReadable(readTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while ((res = delegate.read(dst)) == 0);
        }
        return res;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

