/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.EnumMap;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.xnio.FileAccess;
import org.xnio.LocalSocketAddress;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Version;
import org.xnio.XnioFileChannel;
import org.xnio.XnioProvider;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public abstract class Xnio {
    static final InetSocketAddress ANY_INET_ADDRESS = new InetSocketAddress(0);
    static final LocalSocketAddress ANY_LOCAL_ADDRESS = new LocalSocketAddress("");
    private static final EnumMap<FileAccess, OptionMap> FILE_ACCESS_OPTION_MAPS;
    private static final RuntimePermission ALLOW_BLOCKING_SETTING;
    private final String name;
    private static final ThreadLocal<Boolean> BLOCKING;

    protected Xnio(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean allowBlocking(boolean newSetting) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ALLOW_BLOCKING_SETTING);
        }
        ThreadLocal<Boolean> threadLocal = BLOCKING;
        try {
            boolean bl = threadLocal.get();
            return bl;
        }
        finally {
            threadLocal.set(newSetting);
        }
    }

    public static boolean isBlockingAllowed() {
        return BLOCKING.get();
    }

    public static void checkBlockingAllowed() throws IllegalStateException {
        if (!BLOCKING.get().booleanValue()) {
            throw new IllegalStateException("Blocking I/O is not allowed on the current thread");
        }
    }

    public static Xnio getInstance(ClassLoader classLoader) {
        return Xnio.doGetInstance(null, ServiceLoader.load(XnioProvider.class, classLoader));
    }

    public static Xnio getInstance() {
        return Xnio.doGetInstance(null, ServiceLoader.load(XnioProvider.class, Xnio.class.getClassLoader()));
    }

    public static Xnio getInstance(String provider, ClassLoader classLoader) {
        return Xnio.doGetInstance(provider, ServiceLoader.load(XnioProvider.class, classLoader));
    }

    public static Xnio getInstance(String provider) {
        return Xnio.doGetInstance(provider, ServiceLoader.load(XnioProvider.class, Xnio.class.getClassLoader()));
    }

    private static Xnio doGetInstance(String provider, ServiceLoader<XnioProvider> serviceLoader) {
        for (XnioProvider xnioProvider : serviceLoader) {
            if (provider != null && !provider.equals(xnioProvider.getName())) continue;
            return xnioProvider.getInstance();
        }
        throw new IllegalArgumentException("No matching XNIO provider found");
    }

    public XnioSsl getSslProvider(OptionMap optionMap) throws GeneralSecurityException {
        throw new GeneralSecurityException("SSL is not enabled in this release");
    }

    public FileChannel openFile(File file, OptionMap options) throws IOException {
        switch (options.get(Options.FILE_ACCESS, FileAccess.READ_WRITE)) {
            case READ_ONLY: {
                return new XnioFileChannel(new RandomAccessFile(file, "r").getChannel());
            }
            case READ_WRITE: {
                return new XnioFileChannel(new RandomAccessFile(file, "rw").getChannel());
            }
        }
        throw new IllegalStateException();
    }

    public FileChannel openFile(String fileName, OptionMap options) throws IOException {
        return this.openFile(new File(fileName), options);
    }

    public FileChannel openFile(File file, FileAccess access) throws IOException {
        if (access == null) {
            throw new IllegalArgumentException("access is null");
        }
        return this.openFile(file, FILE_ACCESS_OPTION_MAPS.get((Object)access));
    }

    public FileChannel openFile(String fileName, FileAccess access) throws IOException {
        if (access == null) {
            throw new IllegalArgumentException("access is null");
        }
        return this.openFile(new File(fileName), FILE_ACCESS_OPTION_MAPS.get((Object)access));
    }

    public abstract XnioWorker createWorker(OptionMap var1) throws IOException, IllegalArgumentException;

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return String.format("XNIO provider \"%s\" <%s@%s>", this.getName(), this.getClass().getName(), Integer.toHexString(this.hashCode()));
    }

    protected String getProperty(String name) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, null));
        }
        return System.getProperty(name);
    }

    protected String getProperty(String name, String defaultValue) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, defaultValue));
        }
        return System.getProperty(name, defaultValue);
    }

    static {
        ALLOW_BLOCKING_SETTING = new RuntimePermission("changeThreadBlockingSetting");
        Logger.getLogger((String)"org.xnio").info((Object)("XNIO Version " + Version.VERSION));
        EnumMap<FileAccess, OptionMap> map = new EnumMap<FileAccess, OptionMap>(FileAccess.class);
        map.put(FileAccess.READ_ONLY, OptionMap.create(Options.FILE_ACCESS, FileAccess.READ_ONLY));
        map.put(FileAccess.READ_WRITE, OptionMap.create(Options.FILE_ACCESS, FileAccess.READ_WRITE));
        FILE_ACCESS_OPTION_MAPS = map;
        BLOCKING = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.TRUE;
            }
        };
    }

    private static final class GetPropertyAction
    implements PrivilegedAction<String> {
        private final String propertyName;
        private final String defaultValue;

        private GetPropertyAction(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.propertyName, this.defaultValue);
        }
    }
}

