/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.EnumMap;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.xnio.Acceptor;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ChannelSource;
import org.xnio.ConnectionChannelThread;
import org.xnio.Connector;
import org.xnio.FileAccess;
import org.xnio.IoFuture;
import org.xnio.LocalSocketAddress;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ReadChannelThread;
import org.xnio.Version;
import org.xnio.WriteChannelThread;
import org.xnio.XnioFileChannel;
import org.xnio.XnioProvider;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.SimpleAcceptingChannel;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.ssl.XnioSsl;

public abstract class Xnio {
    private static final InetSocketAddress ANY_INET_ADDRESS = new InetSocketAddress(0);
    private static final LocalSocketAddress ANY_LOCAL_ADDRESS = new LocalSocketAddress("");
    private static final EnumMap<FileAccess, OptionMap> FILE_ACCESS_OPTION_MAPS;
    private static final RuntimePermission ALLOW_BLOCKING_SETTING;
    private final String name;
    private static final ThreadLocal<Boolean> BLOCKING;

    protected Xnio(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean allowBlocking(boolean newSetting) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ALLOW_BLOCKING_SETTING);
        }
        ThreadLocal<Boolean> threadLocal = BLOCKING;
        try {
            boolean bl = threadLocal.get();
            return bl;
        }
        finally {
            threadLocal.set(newSetting);
        }
    }

    public static boolean isBlockingAllowed() {
        return BLOCKING.get();
    }

    public static void checkBlockingAllowed() throws IllegalStateException {
        if (!BLOCKING.get().booleanValue()) {
            throw new IllegalStateException("Blocking I/O is not allowed on the current thread");
        }
    }

    public static Xnio getInstance(ClassLoader classLoader) {
        return Xnio.doGetInstance(null, ServiceLoader.load(XnioProvider.class, classLoader));
    }

    public static Xnio getInstance() {
        return Xnio.doGetInstance(null, ServiceLoader.load(XnioProvider.class, Xnio.class.getClassLoader()));
    }

    public static Xnio getInstance(String provider, ClassLoader classLoader) {
        return Xnio.doGetInstance(provider, ServiceLoader.load(XnioProvider.class, classLoader));
    }

    public static Xnio getInstance(String provider) {
        return Xnio.doGetInstance(provider, ServiceLoader.load(XnioProvider.class, Xnio.class.getClassLoader()));
    }

    private static Xnio doGetInstance(String provider, ServiceLoader<XnioProvider> serviceLoader) {
        for (XnioProvider xnioProvider : serviceLoader) {
            if (provider != null && !provider.equals(xnioProvider.getName())) continue;
            return xnioProvider.getInstance();
        }
        throw new IllegalArgumentException("No matching XNIO provider found");
    }

    public XnioSsl getSslProvider(OptionMap optionMap) throws GeneralSecurityException {
        throw new GeneralSecurityException("SSL is not enabled in this release");
    }

    public AcceptingChannel<? extends ConnectedStreamChannel> createStreamServer(SocketAddress bindAddress, ConnectionChannelThread thread, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (bindAddress instanceof InetSocketAddress) {
            return this.createTcpServer((InetSocketAddress)bindAddress, thread, acceptListener, optionMap);
        }
        if (bindAddress instanceof LocalSocketAddress) {
            return this.createLocalStreamServer((LocalSocketAddress)bindAddress, thread, acceptListener, optionMap);
        }
        throw new UnsupportedOperationException("Unsupported socket address " + bindAddress.getClass());
    }

    protected AcceptingChannel<? extends ConnectedStreamChannel> createTcpServer(InetSocketAddress bindAddress, ConnectionChannelThread thread, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("TCP server");
    }

    protected AcceptingChannel<? extends ConnectedStreamChannel> createLocalStreamServer(LocalSocketAddress bindAddress, ConnectionChannelThread thread, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("UNIX stream server");
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectStreamTcp(ANY_INET_ADDRESS, (InetSocketAddress)destination, thread, readThread, writeThread, openListener, null, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectStreamLocal(ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, thread, readThread, writeThread, openListener, null, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectStreamTcp(ANY_INET_ADDRESS, (InetSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectStreamLocal(ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress bindAddress, SocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (bindAddress.getClass() != destination.getClass()) {
            throw new IllegalArgumentException("Bind address " + bindAddress.getClass() + " is not the same type as destination address " + destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectStreamTcp((InetSocketAddress)bindAddress, (InetSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectStreamLocal((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to stream server with socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedStreamChannel> connectStreamTcp(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to TCP server");
    }

    protected IoFuture<ConnectedStreamChannel> connectStreamLocal(LocalSocketAddress bindAddress, LocalSocketAddress destinationAddress, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to local stream server");
    }

    public Connector<ConnectedStreamChannel> createStreamConnector(final SocketAddress bindAddress, final ConnectionChannelThread thread, final ReadChannelThread readThread, final WriteChannelThread writeThread, final OptionMap optionMap) {
        return new Connector<ConnectedStreamChannel>(){

            @Override
            public IoFuture<ConnectedStreamChannel> connectTo(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return Xnio.this.connectStream(bindAddress, destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
            }
        };
    }

    public IoFuture<ConnectedStreamChannel> acceptStream(SocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.acceptStreamTcp((InetSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptStreamLocal((LocalSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Accept a connection to socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedStreamChannel> acceptStreamLocal(LocalSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOptionException("Accept a local stream connection");
    }

    protected IoFuture<ConnectedStreamChannel> acceptStreamTcp(InetSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOptionException("Accept a TCP connection");
    }

    public Acceptor<ConnectedStreamChannel> createStreamAcceptor(final ConnectionChannelThread thread, final ReadChannelThread readThread, final WriteChannelThread writeThread, final OptionMap optionMap) {
        return new Acceptor<ConnectedStreamChannel>(){

            @Override
            public IoFuture<ConnectedStreamChannel> acceptTo(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return Xnio.this.acceptStream(destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
            }
        };
    }

    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectDatagramUdp(ANY_INET_ADDRESS, (InetSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectDatagramLocal(ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to datagram server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress bindAddress, SocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (bindAddress.getClass() != destination.getClass()) {
            throw new IllegalArgumentException("Bind address " + bindAddress.getClass() + " is not the same type as destination address " + destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectDatagramUdp((InetSocketAddress)bindAddress, (InetSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectDatagramLocal((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedMessageChannel> connectDatagramUdp(InetSocketAddress bindAddress, InetSocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to UDP server");
    }

    protected IoFuture<ConnectedMessageChannel> connectDatagramLocal(LocalSocketAddress bindAddress, LocalSocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to local datagram server");
    }

    public Connector<ConnectedMessageChannel> createDatagramConnector(final SocketAddress bindAddress, final ConnectionChannelThread thread, final OptionMap optionMap) {
        return new Connector<ConnectedMessageChannel>(){

            @Override
            public IoFuture<ConnectedMessageChannel> connectTo(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return Xnio.this.connectDatagram(bindAddress, destination, thread, openListener, bindListener, optionMap);
            }
        };
    }

    public IoFuture<ConnectedMessageChannel> acceptDatagram(SocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptDatagramLocal((LocalSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Accept a connection to socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedMessageChannel> acceptDatagramLocal(LocalSocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOptionException("Accept a local message connection");
    }

    public Acceptor<ConnectedMessageChannel> createMessageAcceptor(final ConnectionChannelThread thread, final OptionMap optionMap) {
        return new Acceptor<ConnectedMessageChannel>(){

            @Override
            public IoFuture<ConnectedMessageChannel> acceptTo(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return Xnio.this.acceptDatagram(destination, thread, openListener, bindListener, optionMap);
            }
        };
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("UDP Server");
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ReadChannelThread readThread, WriteChannelThread writeThread, OptionMap optionMap) throws IOException {
        return this.createUdpServer(bindAddress, readThread, writeThread, ChannelListeners.nullChannelListener(), optionMap);
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ReadChannelThread readThread, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        return this.createUdpServer(bindAddress, readThread, null, bindListener, optionMap);
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ReadChannelThread readThread, OptionMap optionMap) throws IOException {
        return this.createUdpServer(bindAddress, readThread, null, ChannelListeners.nullChannelListener(), optionMap);
    }

    public ChannelSource<? extends StreamChannel> createPipeServer(ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super SimpleAcceptingChannel<StreamChannel>> acceptListener) {
        throw new UnsupportedOperationException("Pipe Server");
    }

    public ChannelSource<? extends StreamSourceChannel> createPipeSourceServer(ReadChannelThread readThread, ChannelListener<? super SimpleAcceptingChannel<StreamSinkChannel>> acceptListener) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public ChannelSource<? extends StreamSinkChannel> createPipeSinkServer(WriteChannelThread writeThread, ChannelListener<? super SimpleAcceptingChannel<StreamSourceChannel>> acceptListener) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public FileChannel openFile(File file, OptionMap options) throws IOException {
        switch (options.get(Options.FILE_ACCESS, FileAccess.READ_WRITE)) {
            case READ_ONLY: {
                return new XnioFileChannel(new RandomAccessFile(file, "r").getChannel());
            }
            case READ_WRITE: {
                return new XnioFileChannel(new RandomAccessFile(file, "rw").getChannel());
            }
        }
        throw new IllegalStateException();
    }

    public FileChannel openFile(String fileName, OptionMap options) throws IOException {
        return this.openFile(new File(fileName), options);
    }

    public FileChannel openFile(File file, FileAccess access) throws IOException {
        if (access == null) {
            throw new IllegalArgumentException("access is null");
        }
        return this.openFile(file, FILE_ACCESS_OPTION_MAPS.get((Object)access));
    }

    public FileChannel openFile(String fileName, FileAccess access) throws IOException {
        if (access == null) {
            throw new IllegalArgumentException("access is null");
        }
        return this.openFile(new File(fileName), FILE_ACCESS_OPTION_MAPS.get((Object)access));
    }

    public abstract ReadChannelThread createReadChannelThread(ThreadGroup var1, OptionMap var2) throws IOException;

    public final ReadChannelThread createReadChannelThread(OptionMap optionMap) throws IOException {
        return this.createReadChannelThread(null, optionMap);
    }

    public final ReadChannelThread createReadChannelThread() throws IOException {
        return this.createReadChannelThread(null, OptionMap.EMPTY);
    }

    public abstract WriteChannelThread createWriteChannelThread(ThreadGroup var1, OptionMap var2) throws IOException;

    public final WriteChannelThread createWriteChannelThread(OptionMap optionMap) throws IOException {
        return this.createWriteChannelThread(null, optionMap);
    }

    public final WriteChannelThread createWriteChannelThread() throws IOException {
        return this.createWriteChannelThread(null, OptionMap.EMPTY);
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return String.format("XNIO provider \"%s\" <%s@%s>", this.getName(), this.getClass().getName(), Integer.toHexString(this.hashCode()));
    }

    protected String getProperty(String name) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, null));
        }
        return System.getProperty(name);
    }

    protected String getProperty(String name, String defaultValue) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, defaultValue));
        }
        return System.getProperty(name, defaultValue);
    }

    static {
        ALLOW_BLOCKING_SETTING = new RuntimePermission("changeThreadBlockingSetting");
        Logger.getLogger((String)"org.xnio").info((Object)("XNIO Version " + Version.VERSION));
        EnumMap<FileAccess, OptionMap> map = new EnumMap<FileAccess, OptionMap>(FileAccess.class);
        map.put(FileAccess.READ_ONLY, OptionMap.create(Options.FILE_ACCESS, FileAccess.READ_ONLY));
        map.put(FileAccess.READ_WRITE, OptionMap.create(Options.FILE_ACCESS, FileAccess.READ_WRITE));
        FILE_ACCESS_OPTION_MAPS = map;
        BLOCKING = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.TRUE;
            }
        };
    }

    private static final class GetPropertyAction
    implements PrivilegedAction<String> {
        private final String propertyName;
        private final String defaultValue;

        private GetPropertyAction(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.propertyName, this.defaultValue);
        }
    }
}

