/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ArraySetUpdater;
import org.xnio.ChannelThread;
import org.xnio.ChannelThreadPool;
import org.xnio.OptionMap;
import org.xnio.ReadChannelThread;
import org.xnio.WriteChannelThread;
import org.xnio.Xnio;

public final class ChannelThreadPools {
    private static final ChannelThread[] NO_THREADS = new ChannelThread[0];
    private static final Logger poolLog = Logger.getLogger((String)"org.xnio.thread-pools");
    static final ArraySetUpdater<SimpleThreadPool, ChannelThread> poolUpdater = ArraySetUpdater.create(AtomicReferenceFieldUpdater.newUpdater(SimpleThreadPool.class, ChannelThread[].class, "pool"), ChannelThread.class);

    private ChannelThreadPools() {
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> createRandomPool() {
        return new Random();
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> createLightestLoadPool() {
        return new LightestLoad();
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> createRoundRobinPool() {
        return new RoundRobin();
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> singleton(T thread) {
        return new Singleton<T>(thread);
    }

    public static ChannelThreadPool<ReadChannelThread> addReadThreadsToPool(Xnio xnio, ChannelThreadPool<ReadChannelThread> pool, int count, OptionMap optionMap) throws IOException {
        return ChannelThreadPools.addReadThreadsToPool(xnio, pool, null, count, optionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelThreadPool<ReadChannelThread> addReadThreadsToPool(Xnio xnio, ChannelThreadPool<ReadChannelThread> pool, ThreadGroup threadGroup, int count, OptionMap optionMap) throws IOException {
        boolean ok = false;
        ArrayList<ReadChannelThread> threads = new ArrayList<ReadChannelThread>(count);
        try {
            for (int i = 0; i < count; ++i) {
                ReadChannelThread thread = xnio.createReadChannelThread(threadGroup, optionMap);
                threads.add(thread);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (ReadChannelThread thread : threads) {
                    thread.shutdown();
                }
            }
        }
        for (ReadChannelThread thread : threads) {
            pool.addToPool(thread);
        }
        return pool;
    }

    public static ChannelThreadPool<WriteChannelThread> addWriteThreadsToPool(Xnio xnio, ChannelThreadPool<WriteChannelThread> pool, int count, OptionMap optionMap) throws IOException {
        return ChannelThreadPools.addWriteThreadsToPool(xnio, pool, null, count, optionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelThreadPool<WriteChannelThread> addWriteThreadsToPool(Xnio xnio, ChannelThreadPool<WriteChannelThread> pool, ThreadGroup threadGroup, int count, OptionMap optionMap) throws IOException {
        boolean ok = false;
        ArrayList<WriteChannelThread> threads = new ArrayList<WriteChannelThread>(count);
        try {
            for (int i = 0; i < count; ++i) {
                WriteChannelThread thread = xnio.createWriteChannelThread(threadGroup, optionMap);
                threads.add(thread);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (WriteChannelThread thread : threads) {
                    thread.shutdown();
                }
            }
        }
        for (WriteChannelThread thread : threads) {
            pool.addToPool(thread);
        }
        return pool;
    }

    public static void shutdown(ChannelThreadPool<?> pool) {
        for (ChannelThread thread : pool.getCurrentPool()) {
            thread.shutdown();
        }
    }

    static /* synthetic */ ChannelThread[] access$200() {
        return NO_THREADS;
    }

    private static class Singleton<T extends ChannelThread>
    implements ChannelThreadPool<T> {
        private final T thread;

        Singleton(T thread) {
            this.thread = thread;
        }

        @Override
        public T getThread() {
            poolLog.tracef("Returning thread %s from pool %s", this.thread, (Object)this);
            return this.thread;
        }

        @Override
        public void addToPool(T thread) {
            throw new IllegalArgumentException("Pool is full");
        }

        @Override
        public void execute(Runnable task) throws RejectedExecutionException {
            this.thread.execute(task);
        }

        @Override
        public ChannelThread.Key executeAfter(Runnable command, long time) {
            return this.thread.executeAfter(command, time);
        }

        @Override
        public List<T> getCurrentPool() {
            return Collections.singletonList(this.thread);
        }
    }

    private static class Random<T extends ChannelThread>
    extends SimpleThreadPool<T> {
        private final java.util.Random random;

        Random() {
            this(new java.util.Random());
        }

        Random(java.util.Random random) {
            this.random = random;
        }

        @Override
        public T getThread() {
            ChannelThread[] pool = this.pool;
            int len = pool.length;
            if (len == 0) {
                return null;
            }
            ChannelThread thread = pool[this.random.nextInt(len)];
            poolLog.tracef("Returning thread %s from pool %s", (Object)thread, (Object)this);
            return (T)thread;
        }
    }

    private static class LightestLoad<T extends ChannelThread>
    extends SimpleThreadPool<T> {
        private LightestLoad() {
        }

        @Override
        public T getThread() {
            ChannelThread[] pool = this.pool;
            int len = pool.length;
            if (len == 0) {
                return null;
            }
            int best = Integer.MAX_VALUE;
            int bestIdx = -1;
            for (int i = 0; i < len; ++i) {
                int load = pool[i].getLoad();
                if (load >= best) continue;
                bestIdx = i;
            }
            ChannelThread thread = pool[bestIdx];
            poolLog.tracef("Returning thread %s from pool %s", (Object)thread, (Object)this);
            return (T)thread;
        }
    }

    private static class RoundRobin<T extends ChannelThread>
    extends SimpleThreadPool<T> {
        private volatile int idx;
        private static final AtomicIntegerFieldUpdater<RoundRobin> idxUpdater = AtomicIntegerFieldUpdater.newUpdater(RoundRobin.class, "idx");

        private RoundRobin() {
        }

        @Override
        public T getThread() {
            ChannelThread[] pool = this.pool;
            int len = pool.length;
            if (len == 0) {
                return null;
            }
            return (T)pool[idxUpdater.getAndIncrement(this) % len];
        }
    }

    private static abstract class SimpleThreadPool<T extends ChannelThread>
    implements ChannelThreadPool<T> {
        private final ChannelThread.Listener listener = new ChannelThread.Listener(){

            @Override
            public void handleTerminationInitiated(ChannelThread thread) {
                thread.removeTerminationListener(this);
                poolUpdater.remove(SimpleThreadPool.this, thread);
            }

            @Override
            public void handleTerminationComplete(ChannelThread thread) {
            }
        };
        volatile T[] pool = ChannelThreadPools.access$200();

        private SimpleThreadPool() {
        }

        @Override
        public void addToPool(T thread) {
            poolLog.tracef("Adding thread %s to pool %s", thread, (Object)this);
            if (!poolUpdater.addAndCheckNull(this, (ChannelThread)thread)) {
                throw new IllegalStateException("Pool is shutting down");
            }
            thread.addTerminationListener(this.listener);
        }

        @Override
        public void execute(Runnable task) {
            Object thread = this.getThread();
            if (thread == null) {
                throw new RejectedExecutionException("No threads available");
            }
            thread.execute(task);
        }

        @Override
        public ChannelThread.Key executeAfter(Runnable command, long time) {
            Object thread = this.getThread();
            if (thread == null) {
                throw new RejectedExecutionException("No threads available");
            }
            return thread.executeAfter(command, time);
        }

        @Override
        public List<T> getCurrentPool() {
            return Collections.unmodifiableList(Arrays.asList(this.pool));
        }
    }
}

