/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.WritableMessageChannel;

final class StreamSinkMessageChannel
implements WritableMessageChannel {
    private final StreamSinkChannel streamChannel;
    private final int maxOutboundMessageSize;
    private final OurSetter writeSetter;
    private final OurSetter closeSetter;
    private final Object writeLock = new Object();
    private final ByteBuffer writeLengthBuf = ByteBuffer.allocate(4);
    private WriteState writeState = WriteState.WAITING;
    private ByteBuffer writeBuffer;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$jboss$xnio$channels$StreamSinkMessageChannel$WriteState;

    StreamSinkMessageChannel(StreamSinkChannel streamChannel, OptionMap optionMap) {
        this.maxOutboundMessageSize = optionMap.get(Options.MAX_OUTBOUND_MESSAGE_SIZE, 2048);
        this.streamChannel = streamChannel;
        this.writeSetter = new OurSetter(streamChannel.getWriteSetter());
        this.closeSetter = new OurSetter(streamChannel.getCloseSetter());
    }

    public ChannelListener.Setter<StreamSinkMessageChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public ChannelListener.Setter<StreamSinkMessageChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public boolean isOpen() {
        return this.streamChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.writeState = WriteState.DOWN;
            this.writeBuffer = null;
        }
        this.streamChannel.close();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.streamChannel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.streamChannel.getOption(option);
    }

    @Override
    public <T> StreamSinkMessageChannel setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        this.streamChannel.setOption(option, value);
        return this;
    }

    @Override
    public boolean send(ByteBuffer buffer) throws IOException {
        return this.send(new ByteBuffer[]{buffer});
    }

    @Override
    public boolean send(ByteBuffer[] buffers) throws IOException {
        return this.send(buffers, 0, buffers.length);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean send(ByteBuffer[] buffers, int offs, int len) throws IOException {
        size = 0;
        i = 0;
        while (i < len) {
            if ((size += buffers[offs + i].remaining()) < 0) break;
            ++i;
        }
        if (size < 0 || size > this.maxOutboundMessageSize) {
            throw new IOException("Message exceeds outbound message size");
        }
        writeLengthBuf = this.writeLengthBuf;
        streamChannel = this.streamChannel;
        var7_8 = this.writeLock;
        synchronized (var7_8) {
            ok = false;
            ** try [egrp 1[TRYBLOCK] [0 : 87->146)] { 
lbl16:
            // 1 sources

            ** GOTO lbl-1000
lbl17:
            // 1 sources

            finally {
                if (!ok) {
                    this.writeState = WriteState.DOWN;
                    this.writeBuffer = null;
                }
            }
lbl-1000:
            // 1 sources

            {
                while (true) {
                    switch (StreamSinkMessageChannel.$SWITCH_TABLE$org$jboss$xnio$channels$StreamSinkMessageChannel$WriteState()[this.writeState.ordinal()]) {
                        case 3: {
                            do {
                                if (writeLengthBuf.hasRemaining()) continue;
                                writeLengthBuf.clear();
                                ** GOTO lbl35
                            } while (streamChannel.write(writeLengthBuf) != 0);
                            ok = true;
                            return false;
                        }
lbl35:
                        // 2 sources

                        case 4: {
                            writeBuffer = this.writeBuffer;
                            do {
                                if (writeBuffer.hasRemaining()) continue;
                                this.writeBuffer = null;
                                ** GOTO lbl44
                            } while (streamChannel.write(writeBuffer) != 0);
                            ok = true;
                            return false;
                        }
lbl44:
                        // 2 sources

                        case 2: {
                            writeLengthBuf.putInt(size).flip();
                            do {
                                if (writeLengthBuf.hasRemaining()) continue;
                                writeLengthBuf.clear();
                                if (true) ** GOTO lbl75
                            } while (streamChannel.write(writeLengthBuf) != 0);
                            writeBuffer = ByteBuffer.allocate(size);
                            i = 0;
                            while (true) {
                                if (i >= len) {
                                    writeBuffer.flip();
                                    this.writeBuffer = writeBuffer;
                                    this.writeState = WriteState.LENGTH;
                                    ok = true;
                                    return false;
                                }
                                writeBuffer.put(buffers[i + offs]);
                                ++i;
                            }
                        }
                        case 1: {
                            throw new ClosedChannelException();
                        }
                    }
                }
                do {
                    if ((res = streamChannel.write(buffers, offs, len)) != 0L) continue;
                    writeBuffer = ByteBuffer.allocate(size);
                    i = 0;
                    if (true) ** GOTO lbl82
lbl75:
                    // 2 sources

                } while (size > 0);
                ok = true;
                return true;
                do {
                    writeBuffer.put(buffers[i + offs]);
                    ++i;
lbl82:
                    // 2 sources

                } while (i < len);
                writeBuffer.flip();
                this.writeBuffer = writeBuffer;
                this.writeState = WriteState.BODY;
                ok = true;
            }
            return true;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean flush() throws IOException {
        var1_1 = this.writeLock;
        synchronized (var1_1) {
            ok = false;
            try {
                switch (StreamSinkMessageChannel.$SWITCH_TABLE$org$jboss$xnio$channels$StreamSinkMessageChannel$WriteState()[this.writeState.ordinal()]) {
                    case 3: {
                        do {
                            if (this.writeLengthBuf.hasRemaining()) continue;
                            this.writeLengthBuf.clear();
                            ** GOTO lbl16
                        } while (this.streamChannel.write(this.writeLengthBuf) != 0);
                        ok = true;
                        return false;
                    }
lbl16:
                    // 2 sources

                    case 4: {
                        writeBuffer = this.writeBuffer;
                        do {
                            if (writeBuffer.hasRemaining()) continue;
                            this.writeBuffer = null;
                            this.writeState = WriteState.WAITING;
                            ok = true;
                            return true;
                        } while (this.streamChannel.write(writeBuffer) != 0);
                        ok = true;
                        return false;
                    }
                    case 1: {
                        throw new ClosedChannelException();
                    }
                }
                ok = true;
                return true;
            }
            finally {
                if (!ok) {
                    this.writeState = WriteState.DOWN;
                    this.writeBuffer = null;
                }
            }
        }
    }

    @Override
    public void suspendWrites() {
        this.streamChannel.suspendWrites();
    }

    @Override
    public void resumeWrites() {
        this.streamChannel.resumeWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdownWrites() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.flush()) {
                this.writeState = WriteState.DOWN;
                this.writeBuffer = null;
                return this.streamChannel.shutdownWrites();
            }
        }
        return false;
    }

    @Override
    public void awaitWritable() throws IOException {
        this.streamChannel.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.streamChannel.awaitWritable(time, timeUnit);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jboss$xnio$channels$StreamSinkMessageChannel$WriteState() {
        if ($SWITCH_TABLE$org$jboss$xnio$channels$StreamSinkMessageChannel$WriteState != null) {
            return $SWITCH_TABLE$org$jboss$xnio$channels$StreamSinkMessageChannel$WriteState;
        }
        int[] nArray = new int[WriteState.values().length];
        try {
            nArray[WriteState.BODY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WriteState.DOWN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WriteState.LENGTH.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WriteState.WAITING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jboss$xnio$channels$StreamSinkMessageChannel$WriteState = nArray;
        return nArray;
    }

    private final class OurSetter
    implements ChannelListener.Setter<StreamSinkMessageChannel> {
        private final ChannelListener.Setter<? extends StreamSinkChannel> setter;

        private OurSetter(ChannelListener.Setter<? extends StreamSinkChannel> setter) {
            this.setter = setter;
        }

        @Override
        public void set(final ChannelListener<? super StreamSinkMessageChannel> channelListener) {
            this.setter.set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<Channel>(){

                @Override
                public void handleEvent(Channel channel) {
                    channelListener.handleEvent(StreamSinkMessageChannel.this);
                }
            });
        }
    }

    private static enum WriteState {
        DOWN,
        WAITING,
        LENGTH,
        BODY;

    }
}

