/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.management.TcpConnectionMBean;

final class ManagedSocket
extends Socket {
    private static final AtomicLongFieldUpdater<ManagedSocket> bytesReadUpdater = AtomicLongFieldUpdater.newUpdater(ManagedSocket.class, "bytesRead");
    private static final AtomicLongFieldUpdater<ManagedSocket> bytesWrittenUpdater = AtomicLongFieldUpdater.newUpdater(ManagedSocket.class, "bytesWritten");
    private static final AtomicLongFieldUpdater<ManagedSocket> msgsReadUpdater = AtomicLongFieldUpdater.newUpdater(ManagedSocket.class, "msgsRead");
    private static final AtomicLongFieldUpdater<ManagedSocket> msgsWrittenUpdater = AtomicLongFieldUpdater.newUpdater(ManagedSocket.class, "msgsWritten");
    private volatile long bytesRead = 0L;
    private volatile long bytesWritten = 0L;
    private volatile long msgsRead = 0L;
    private volatile long msgsWritten = 0L;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Closeable registration;

    ManagedSocket() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedSocket configure(OptionMap optionMap) throws IOException {
        ManagedSocket managedSocket = this;
        synchronized (managedSocket) {
            super.setTcpNoDelay(optionMap.get(Options.TCP_NODELAY, false));
            super.setKeepAlive(optionMap.get(Options.KEEP_ALIVE, false));
            super.setOOBInline(optionMap.get(Options.TCP_OOB_INLINE, false));
            if (optionMap.contains(Options.RECEIVE_BUFFER)) {
                super.setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, 0));
            }
            super.setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, false));
            if (optionMap.contains(Options.SEND_BUFFER)) {
                super.setSendBufferSize(optionMap.get(Options.SEND_BUFFER, 0));
            }
            if (optionMap.contains(Options.IP_TRAFFIC_CLASS)) {
                super.setTrafficClass(optionMap.get(Options.IP_TRAFFIC_CLASS, 0));
            }
        }
        return this;
    }

    MBean getMBean() throws NotCompliantMBeanException {
        return new MBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        ManagedSocket managedSocket = this;
        synchronized (managedSocket) {
            InputStream inputStream = this.inputStream;
            if (inputStream == null) {
                this.inputStream = new Input(super.getInputStream());
                return this.inputStream;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        ManagedSocket managedSocket = this;
        synchronized (managedSocket) {
            OutputStream outputStream = this.outputStream;
            if (outputStream == null) {
                this.outputStream = new Output(super.getOutputStream());
                return this.outputStream;
            }
            return outputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegistration(Closeable closeable) {
        ManagedSocket managedSocket = this;
        synchronized (managedSocket) {
            this.registration = closeable;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            IoUtils.safeClose(this.registration);
        }
    }

    private final class Input
    extends FilterInputStream {
        protected Input(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int cnt = this.in.read(b, off, len);
            if (cnt > 0) {
                bytesReadUpdater.getAndAdd(ManagedSocket.this, cnt);
                msgsReadUpdater.getAndIncrement(ManagedSocket.this);
            }
            return cnt;
        }

        @Override
        public int read() throws IOException {
            int val = this.in.read();
            if (val >= 0) {
                bytesReadUpdater.getAndIncrement(ManagedSocket.this);
                msgsReadUpdater.getAndIncrement(ManagedSocket.this);
            }
            return val;
        }

        @Override
        public long skip(long n) throws IOException {
            long cnt = this.in.skip(n);
            if (cnt > 0L) {
                bytesReadUpdater.getAndAdd(ManagedSocket.this, cnt);
            }
            return cnt;
        }
    }

    private final class MBean
    extends StandardMBean
    implements TcpConnectionMBean {
        public MBean() throws NotCompliantMBeanException {
            super(TcpConnectionMBean.class);
        }

        @Override
        public long getBytesRead() {
            return ManagedSocket.this.bytesRead;
        }

        @Override
        public long getBytesWritten() {
            return ManagedSocket.this.bytesWritten;
        }

        @Override
        public long getMessagesRead() {
            return ManagedSocket.this.msgsRead;
        }

        @Override
        public long getMessagesWritten() {
            return ManagedSocket.this.msgsWritten;
        }

        public String toString() {
            return "ChannelMBean";
        }

        @Override
        public InetSocketAddress getPeerAddress() {
            return (InetSocketAddress)ManagedSocket.this.getRemoteSocketAddress();
        }

        @Override
        public InetSocketAddress getBindAddress() {
            InetSocketAddress lsa = (InetSocketAddress)ManagedSocket.this.getLocalSocketAddress();
            if (lsa == null) {
                return new InetSocketAddress(0);
            }
            return lsa;
        }

        @Override
        public void close() {
            IoUtils.safeClose(ManagedSocket.this);
        }
    }

    private final class Output
    extends FilterOutputStream {
        protected Output(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            bytesWrittenUpdater.getAndIncrement(ManagedSocket.this);
            msgsWrittenUpdater.getAndIncrement(ManagedSocket.this);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            bytesWrittenUpdater.getAndAdd(ManagedSocket.this, len);
            msgsWrittenUpdater.getAndIncrement(ManagedSocket.this);
        }
    }
}

