/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.Sequence;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.SslTcpChannel;
import org.jboss.xnio.channels.TcpChannel;

final class WrappingSslTcpChannel
implements SslTcpChannel {
    private final TcpChannel tcpChannel;
    private final SSLEngine sslEngine;
    private final Executor executor;
    private volatile ChannelListener<? super SslTcpChannel> readListener = null;
    private volatile ChannelListener<? super SslTcpChannel> writeListener = null;
    private volatile ChannelListener<? super SslTcpChannel> closeListener = null;
    private static final AtomicReferenceFieldUpdater<WrappingSslTcpChannel, ChannelListener> readListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(WrappingSslTcpChannel.class, ChannelListener.class, "readListener");
    private static final AtomicReferenceFieldUpdater<WrappingSslTcpChannel, ChannelListener> writeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(WrappingSslTcpChannel.class, ChannelListener.class, "writeListener");
    private static final AtomicReferenceFieldUpdater<WrappingSslTcpChannel, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(WrappingSslTcpChannel.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<SslTcpChannel> readSetter = IoUtils.getSetter(this, readListenerUpdater);
    private final ChannelListener.Setter<SslTcpChannel> writeSetter = IoUtils.getSetter(this, writeListenerUpdater);
    private final ChannelListener.Setter<SslTcpChannel> closeSetter = IoUtils.getSetter(this, closeListenerUpdater);
    private final ChannelListener<TcpChannel> tcpCloseListener = new ChannelListener<TcpChannel>(){

        @Override
        public void handleEvent(TcpChannel channel) {
            IoUtils.safeClose(WrappingSslTcpChannel.this);
            IoUtils.invokeChannelListener(WrappingSslTcpChannel.this, WrappingSslTcpChannel.this.closeListener);
        }
    };
    private final Runnable readTriggeredTask = new Runnable(){

        @Override
        public void run() {
            WrappingSslTcpChannel.this.runReadListener();
        }
    };
    private final ChannelListener<TcpChannel> tcpReadListener = new ChannelListener<TcpChannel>(){

        @Override
        public void handleEvent(TcpChannel channel) {
            boolean runRead = false;
            boolean runWrite = false;
            Lock mainLock = WrappingSslTcpChannel.this.mainLock;
            mainLock.lock();
            try {
                if (!WrappingSslTcpChannel.this.needsWrap) {
                    WrappingSslTcpChannel.this.readAwaiters.signalAll();
                    if (WrappingSslTcpChannel.this.userReads) {
                        WrappingSslTcpChannel.this.userReads = false;
                        runRead = true;
                    }
                }
                if (WrappingSslTcpChannel.this.userWrites && WrappingSslTcpChannel.this.needsUnwrap) {
                    WrappingSslTcpChannel.this.userWrites = false;
                    runWrite = true;
                }
            }
            finally {
                mainLock.unlock();
            }
            if (runRead) {
                WrappingSslTcpChannel.this.runReadListener();
            }
            if (runWrite) {
                WrappingSslTcpChannel.this.runWriteListener();
            }
        }
    };
    private final ChannelListener<TcpChannel> tcpWriteListener = new ChannelListener<TcpChannel>(){

        @Override
        public void handleEvent(TcpChannel channel) {
            boolean runRead = false;
            boolean runWrite = false;
            Lock mainLock = WrappingSslTcpChannel.this.mainLock;
            mainLock.lock();
            try {
                if (WrappingSslTcpChannel.this.needsWrap) {
                    WrappingSslTcpChannel.this.readAwaiters.signalAll();
                }
                if (WrappingSslTcpChannel.this.userWrites && !WrappingSslTcpChannel.this.needsUnwrap) {
                    WrappingSslTcpChannel.this.userWrites = false;
                    runWrite = true;
                }
                if (WrappingSslTcpChannel.this.userReads && WrappingSslTcpChannel.this.needsWrap) {
                    WrappingSslTcpChannel.this.userReads = false;
                    runRead = true;
                }
            }
            finally {
                mainLock.unlock();
            }
            if (runRead) {
                WrappingSslTcpChannel.this.runReadListener();
            }
            if (runWrite) {
                WrappingSslTcpChannel.this.runWriteListener();
            }
        }
    };
    private final Lock mainLock = new ReentrantLock();
    private final Condition readAwaiters = this.mainLock.newCondition();
    private boolean userReads;
    private boolean userWrites;
    private boolean needsWrap;
    private boolean needsUnwrap;
    private ByteBuffer readBuffer = Buffers.EMPTY_BYTE_BUFFER;
    private ByteBuffer receiveBuffer = Buffers.EMPTY_BYTE_BUFFER;
    private ByteBuffer sendBuffer;
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(CommonOptions.SSL_ENABLED_CIPHER_SUITES).add(CommonOptions.SSL_ENABLED_PROTOCOLS).add(CommonOptions.SSL_SUPPORTED_CIPHER_SUITES).add(CommonOptions.SSL_SUPPORTED_PROTOCOLS).create();

    private void runReadListener() {
        IoUtils.invokeChannelListener(this, this.readListener);
    }

    private void runWriteListener() {
        IoUtils.invokeChannelListener(this, this.writeListener);
    }

    WrappingSslTcpChannel(TcpChannel tcpChannel, SSLEngine sslEngine, Executor executor) {
        this.tcpChannel = tcpChannel;
        this.sslEngine = sslEngine;
        this.executor = executor;
        tcpChannel.getReadSetter().set(this.tcpReadListener);
        tcpChannel.getWriteSetter().set(this.tcpWriteListener);
        tcpChannel.getCloseSetter().set(this.tcpCloseListener);
    }

    @Override
    public InetSocketAddress getPeerAddress() {
        return (InetSocketAddress)this.tcpChannel.getPeerAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.tcpChannel.getLocalAddress();
    }

    @Override
    public void startHandshake() throws IOException {
        this.sslEngine.beginHandshake();
    }

    @Override
    public SSLSession getSslSession() {
        return this.sslEngine.getSession();
    }

    @Override
    public ChannelListener.Setter<SslTcpChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public ChannelListener.Setter<SslTcpChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public ChannelListener.Setter<SslTcpChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public boolean flush() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            boolean bl = this.doFlush();
            return bl;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean doFlush() throws IOException {
        tcpChannel = this.tcpChannel;
        block22: while (true) {
            sendBuffer = this.sendBuffer;
            sendBuffer.flip();
            try {
                while (sendBuffer.hasRemaining()) {
                    if (tcpChannel.write(sendBuffer) != 0) continue;
                    return false;
                }
            }
            finally {
                sendBuffer.compact();
            }
            sslEngine = this.sslEngine;
            wrapResult = sslEngine.wrap(Buffers.EMPTY_BYTE_BUFFER, sendBuffer);
            produced = wrapResult.bytesProduced();
            switch (WrappingSslTcpChannel.$SWITCH_TABLE$javax$net$ssl$SSLEngineResult$Status()[wrapResult.getStatus().ordinal()]) {
                case 4: {
                    tcpChannel.shutdownWrites();
                    return true;
                }
                case 1: 
                case 3: {
                    if (produced > 0) continue block22;
                    switch (WrappingSslTcpChannel.$SWITCH_TABLE$javax$net$ssl$SSLEngineResult$HandshakeStatus()[wrapResult.getHandshakeStatus().ordinal()]) {
                        case 1: 
                        case 2: {
                            return true;
                        }
                        case 3: {
                            sslEngine.getDelegatedTask().run();
                            continue block22;
                        }
                        case 5: {
                            block24: while (true) {
                                receiveBuffer = this.receiveBuffer;
                                unwrapResult = sslEngine.unwrap(receiveBuffer, this.readBuffer);
                                this.readAwaiters.signalAll();
                                switch (WrappingSslTcpChannel.$SWITCH_TABLE$javax$net$ssl$SSLEngineResult$Status()[unwrapResult.getStatus().ordinal()]) {
                                    case 1: {
                                        if (receiveBuffer.position() == 0 && receiveBuffer.limit() == receiveBuffer.capacity()) {
                                            pktBufSize = sslEngine.getSession().getPacketBufferSize();
                                            if (receiveBuffer.capacity() >= pktBufSize) {
                                                throw new IOException("Unexpected/inexplicable buffer underflow from the SSL engine");
                                            }
                                            this.receiveBuffer = Buffers.flip(ByteBuffer.allocate(pktBufSize).put(receiveBuffer));
                                            continue block24;
                                        }
                                        receiveBuffer.compact();
                                        try {
                                            res = tcpChannel.read(receiveBuffer);
                                            if (res == -1) {
                                                sslEngine.closeInbound();
                                                continue block22;
                                            }
                                            if (res == 0) ** break;
                                            continue block24;
                                            this.needsUnwrap = true;
                                            return false;
                                        }
                                        finally {
                                            receiveBuffer.flip();
                                            continue block22;
                                        }
                                    }
                                    case 4: {
                                        return true;
                                    }
                                    case 3: {
                                        continue block22;
                                    }
                                }
                                break;
                            }
                            throw new IOException("Unexpected unwrap result status " + (Object)unwrapResult.getStatus());
                        }
                    }
                    throw new IOException("Unexpected wrap result handshake status " + (Object)wrapResult.getStatus());
                }
            }
            break;
        }
        throw new IOException("Unexpected wrap result status " + (Object)wrapResult.getStatus());
    }

    @Override
    public boolean isOpen() {
        return this.tcpChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.sslEngine.closeOutbound();
            IOException e1 = null;
            IOException e2 = null;
            try {
                this.sslEngine.closeInbound();
            }
            catch (IOException e) {
                e1 = e;
            }
            try {
                this.tcpChannel.close();
            }
            catch (IOException e) {
                e2 = e;
            }
            if (e1 != null && e2 != null) {
                IOException t = new IOException("Multiple failures on close!  The second exception is: " + e2.toString());
                t.initCause(e1);
                throw t;
            }
            if (e1 != null) {
                throw e1;
            }
            if (e2 != null) {
                throw e2;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option) || this.tcpChannel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == CommonOptions.SSL_ENABLED_CIPHER_SUITES) {
            return option.cast(Sequence.of(this.sslEngine.getEnabledCipherSuites()));
        }
        if (option == CommonOptions.SSL_SUPPORTED_CIPHER_SUITES) {
            return option.cast(Sequence.of(this.sslEngine.getSupportedCipherSuites()));
        }
        if (option == CommonOptions.SSL_ENABLED_PROTOCOLS) {
            return option.cast(Sequence.of(this.sslEngine.getEnabledProtocols()));
        }
        if (option == CommonOptions.SSL_SUPPORTED_PROTOCOLS) {
            return option.cast(Sequence.of(this.sslEngine.getSupportedProtocols()));
        }
        return this.tcpChannel.getOption(option);
    }

    @Override
    public <T> Configurable setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == CommonOptions.SSL_ENABLED_CIPHER_SUITES) {
            Sequence<String> strings = CommonOptions.SSL_ENABLED_CIPHER_SUITES.cast(value);
            this.sslEngine.setEnabledCipherSuites(strings.toArray((String[])new String[strings.size()]));
        } else if (option == CommonOptions.SSL_ENABLED_PROTOCOLS) {
            Sequence<String> strings = CommonOptions.SSL_ENABLED_PROTOCOLS.cast(value);
            this.sslEngine.setEnabledProtocols(strings.toArray((String[])new String[strings.size()]));
        } else {
            this.tcpChannel.setOption(option, value);
        }
        return this;
    }

    @Override
    public void suspendReads() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.userReads = false;
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void suspendWrites() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.userWrites = false;
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void resumeReads() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.readBuffer.hasRemaining()) {
                this.executor.execute(this.readTriggeredTask);
            } else {
                if (this.needsWrap) {
                    this.tcpChannel.resumeWrites();
                } else {
                    this.tcpChannel.resumeReads();
                }
                this.userReads = true;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void resumeWrites() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.needsUnwrap) {
                this.tcpChannel.resumeReads();
            } else {
                this.tcpChannel.resumeWrites();
            }
            this.userWrites = true;
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void shutdownReads() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.tcpChannel.shutdownReads();
            this.sslEngine.closeInbound();
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void shutdownWrites() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.sslEngine.closeOutbound();
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        block7: {
            Lock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.readBuffer.hasRemaining()) break block7;
                try {
                    if (this.needsWrap) {
                        this.tcpChannel.resumeWrites();
                    } else {
                        this.tcpChannel.resumeReads();
                    }
                    this.readAwaiters.await();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        block7: {
            Lock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.readBuffer.hasRemaining()) break block7;
                try {
                    if (this.needsWrap) {
                        this.tcpChannel.resumeWrites();
                    } else {
                        this.tcpChannel.resumeReads();
                    }
                    this.readAwaiters.await(time, timeUnit);
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    @Override
    public void awaitWritable() throws IOException {
        this.tcpChannel.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.tcpChannel.awaitWritable(time, timeUnit);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return (int)this.write(new ByteBuffer[]{src}, 0, 1);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        block38: {
            sslEngine = this.sslEngine;
            mainLock = this.mainLock;
            mainLock.lock();
            sendBuffer = this.sendBuffer;
lbl6:
            // 4 sources

            block30: while (true) {
                wrapResult = sslEngine.wrap(srcs, offset, length, sendBuffer);
                produced = wrapResult.bytesProduced();
                consumed = wrapResult.bytesConsumed();
                tcpChannel = this.tcpChannel;
                switch (WrappingSslTcpChannel.$SWITCH_TABLE$javax$net$ssl$SSLEngineResult$Status()[wrapResult.getStatus().ordinal()]) {
                    case 2: {
                        if (sendBuffer.position() == 0) {
                            oldCap = sendBuffer.capacity();
                            reqCap = sslEngine.getSession().getPacketBufferSize();
                            if (reqCap <= oldCap) {
                                throw new IOException("SSLEngine required a bigger send buffer but our buffer was already big enough");
                            }
                            sendBuffer = this.sendBuffer = ByteBuffer.allocate(reqCap);
                            continue block30;
                        }
                        sendBuffer.flip();
                        try {
                            res = tcpChannel.write(sendBuffer);
                            if (res == 0) {
                                var13_17 = consumed;
                                return var13_17;
                            }
                        }
                        finally {
                            sendBuffer.compact();
                        }
                    }
                    case 1: {
                        var18_18 = consumed;
                        return var18_18;
                    }
                    case 4: {
                        throw new ClosedChannelException();
                    }
                    case 3: {
                        if (consumed != 0) {
                            var18_20 = consumed;
                            return var18_20;
                        }
                        if (produced > 0) continue block30;
                        switch (WrappingSslTcpChannel.$SWITCH_TABLE$javax$net$ssl$SSLEngineResult$HandshakeStatus()[wrapResult.getHandshakeStatus().ordinal()]) {
                            case 3: {
                                sslEngine.getDelegatedTask().run();
                                continue block30;
                            }
                            case 5: {
                                break block38;
                            }
                            default: {
                                throw new IOException("Unexpected handshake state " + (Object)wrapResult.getHandshakeStatus() + " on wrap");
                            }
                        }
                    }
                    default: {
                        throw new IOException("Unexpected wrap result status " + (Object)wrapResult.getStatus());
                    }
                }
                break;
            }
            finally {
                mainLock.unlock();
            }
        }
        block31: while (true) {
            receiveBuffer = this.receiveBuffer;
            unwrapResult = sslEngine.unwrap(receiveBuffer, this.readBuffer);
            this.readAwaiters.signalAll();
            switch (WrappingSslTcpChannel.$SWITCH_TABLE$javax$net$ssl$SSLEngineResult$Status()[unwrapResult.getStatus().ordinal()]) {
                case 1: {
                    if (receiveBuffer.position() == 0 && receiveBuffer.limit() == receiveBuffer.capacity()) {
                        pktBufSize = sslEngine.getSession().getPacketBufferSize();
                        if (receiveBuffer.capacity() >= pktBufSize) {
                            throw new IOException("Unexpected/inexplicable buffer underflow from the SSL engine");
                        }
                        this.receiveBuffer = Buffers.flip(ByteBuffer.allocate(pktBufSize).put(receiveBuffer));
                        continue block31;
                    }
                    receiveBuffer.compact();
                    try {
                        res = tcpChannel.read(receiveBuffer);
                        if (res != -1) ** GOTO lbl75
                        sslEngine.closeInbound();
                        ** GOTO lbl6
lbl75:
                        // 1 sources

                        if (res == 0) ** break;
                        continue block31;
                        this.needsUnwrap = true;
                        var15_21 = consumed;
                        return var15_21;
                    }
                    finally {
                        receiveBuffer.flip();
                        ** GOTO lbl6
                    }
                }
                case 4: {
                    var18_19 = consumed == 0 ? -1 : consumed;
                    return var18_19;
                }
                case 3: {
                    ** continue;
                }
            }
            break;
        }
        throw new IOException("Unexpected unwrap result status " + (Object)unwrapResult.getStatus());
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return (int)this.read(new ByteBuffer[]{dst}, 0, 1);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            ByteBuffer readBuffer = this.readBuffer;
            int r = readBuffer.remaining();
            if (r > 0) {
                long l = Buffers.put(dsts, offset, length, readBuffer);
                return l;
            }
            TcpChannel tcpChannel = this.tcpChannel;
            SSLEngine sslEngine = this.sslEngine;
            block29: while (true) {
                ByteBuffer receiveBuffer = this.receiveBuffer;
                ByteBuffer[] target = new ByteBuffer[length + 1];
                System.arraycopy(dsts, offset, target, 0, length);
                target[length] = readBuffer;
                SSLEngineResult unwrapResult = sslEngine.unwrap(receiveBuffer, target);
                if (!receiveBuffer.hasRemaining()) {
                    receiveBuffer.clear();
                }
                int produced = unwrapResult.bytesProduced();
                switch (unwrapResult.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        assert (readBuffer.position() == 0);
                        int appBufSize = sslEngine.getSession().getApplicationBufferSize();
                        if (readBuffer.capacity() >= appBufSize) {
                            throw new IOException("Unexpected/inexplicable buffer overflow from the SSL engine");
                        }
                        this.readBuffer = ByteBuffer.allocate(appBufSize);
                        continue block29;
                    }
                    case BUFFER_UNDERFLOW: {
                        int rres;
                        if (receiveBuffer.position() == 0 && receiveBuffer.limit() == receiveBuffer.capacity()) {
                            int pktBufSize = sslEngine.getSession().getPacketBufferSize();
                            if (receiveBuffer.capacity() >= pktBufSize) {
                                throw new IOException("Unexpected/inexplicable buffer underflow from the SSL engine");
                            }
                            this.receiveBuffer = Buffers.flip(ByteBuffer.allocate(pktBufSize).put(receiveBuffer));
                            continue block29;
                        }
                        receiveBuffer.compact();
                        try {
                            rres = tcpChannel.read(receiveBuffer);
                        }
                        finally {
                            if (receiveBuffer.position() > 0) {
                                receiveBuffer.flip();
                            }
                        }
                        if (rres == -1) {
                            sslEngine.closeInbound();
                            continue block29;
                        }
                        if (rres != 0) continue block29;
                        return 0L;
                    }
                    case CLOSED: {
                        this.needsUnwrap = false;
                        return -1L;
                    }
                    case OK: {
                        this.needsUnwrap = false;
                        if (produced > 0) {
                            if (produced > r) {
                                readBuffer.flip();
                                this.readAwaiters.signalAll();
                                long l = r;
                                return l;
                            }
                            long l = produced;
                            return l;
                        }
                        switch (unwrapResult.getHandshakeStatus()) {
                            case NEED_TASK: {
                                sslEngine.getDelegatedTask().run();
                                continue block29;
                            }
                            case NEED_WRAP: {
                                SSLEngineResult wrapResult;
                                block30: while (true) {
                                    ByteBuffer sendBuffer = this.sendBuffer;
                                    wrapResult = sslEngine.wrap(Buffers.EMPTY_BYTE_BUFFER, sendBuffer);
                                    switch (wrapResult.getStatus()) {
                                        case BUFFER_OVERFLOW: {
                                            int pktBufSize = sslEngine.getSession().getPacketBufferSize();
                                            if (sendBuffer.capacity() < pktBufSize) {
                                                this.sendBuffer = ByteBuffer.allocate(pktBufSize);
                                                this.sendBuffer.put(sendBuffer).flip();
                                                continue block30;
                                            }
                                            sendBuffer.flip();
                                            try {
                                                int res = tcpChannel.write(sendBuffer);
                                                if (res == 0) {
                                                    this.needsWrap = true;
                                                    return 0L;
                                                }
                                            }
                                            finally {
                                                sendBuffer.compact();
                                            }
                                            {
                                            }
                                        }
                                        case OK: {
                                            this.needsWrap = false;
                                            continue block29;
                                        }
                                    }
                                    break;
                                }
                                throw new IOException("Unexpected status of " + (Object)((Object)wrapResult.getStatus()) + " while wrapping for an unwrap");
                            }
                        }
                        throw new IOException("Unexpected handshake status of " + (Object)((Object)unwrapResult.getHandshakeStatus()) + " while unwrapping");
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }
}

