/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.Selector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Handler;
import java.util.zip.ZipFile;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.CloseableExecutor;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.log.Logger;

public final class IoUtils {
    private static final Executor NULL_EXECUTOR = new Executor(){
        private final String string = String.format("null executor <%s>", Integer.toHexString(this.hashCode()));

        @Override
        public void execute(Runnable command) {
        }

        public String toString() {
            return this.string;
        }
    };
    private static final Executor DIRECT_EXECUTOR = new Executor(){
        private final String string = String.format("direct executor <%s>", Integer.toHexString(this.hashCode()));

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        public String toString() {
            return this.string;
        }
    };
    private static final Closeable NULL_CLOSEABLE = new Closeable(){
        private final String string = String.format("null closeable <%s>", Integer.toHexString(this.hashCode()));

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.string;
        }
    };
    private static final Logger closeLog = Logger.getLogger("org.jboss.xnio.safe-close");
    private static final IoFuture.Notifier<Object, Closeable> ATTACHMENT_CLOSING_NOTIFIER = new IoFuture.Notifier<Object, Closeable>(){

        @Override
        public void notify(IoFuture<?> future, Closeable attachment) {
            IoUtils.safeClose(attachment);
        }
    };
    private static final IoFuture.Notifier<Closeable, Void> CLOSING_NOTIFIER = new IoFuture.HandlingNotifier<Closeable, Void>(){

        @Override
        public void handleDone(Closeable result, Void attachment) {
            IoUtils.safeClose(result);
        }
    };
    private static final IoFuture.Notifier<Object, CountDownLatch> COUNT_DOWN_NOTIFIER = new IoFuture.Notifier<Object, CountDownLatch>(){

        @Override
        public void notify(IoFuture<?> future, CountDownLatch latch) {
            latch.countDown();
        }
    };
    private static final Logger listenerLog = Logger.getLogger("org.jboss.xnio.channel-listener");
    private static ChannelListener<Channel> CLOSING_CHANNEL_LISTENER = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            IoUtils.safeClose(channel);
        }
    };

    private IoUtils() {
    }

    public static Executor directExecutor() {
        return DIRECT_EXECUTOR;
    }

    public static Executor nullExecutor() {
        return NULL_EXECUTOR;
    }

    public static CloseableExecutor closeableExecutor(final ExecutorService executorService, final long timeout, final TimeUnit unit) {
        return new CloseableExecutor(){

            @Override
            public void close() throws IOException {
                executorService.shutdown();
                try {
                    if (executorService.awaitTermination(timeout, unit)) {
                        return;
                    }
                    executorService.shutdownNow();
                    throw new IOException("Executor did not shut down cleanly (killed)");
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    executorService.shutdownNow();
                    throw new InterruptedIOException("Interrupted while awaiting executor shutdown");
                }
            }

            @Override
            public void execute(Runnable command) {
                executorService.execute(command);
            }
        };
    }

    public static Closeable nullCloseable() {
        return NULL_CLOSEABLE;
    }

    public static void safeClose(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(Socket resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(DatagramSocket resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(Selector resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(ServerSocket resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(ZipFile resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(Handler resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(IoFuture<? extends Closeable> futureResource) {
        futureResource.cancel().addNotifier(IoUtils.closingNotifier(), null);
    }

    public static IoFuture.Notifier<Object, Closeable> attachmentClosingNotifier() {
        return ATTACHMENT_CLOSING_NOTIFIER;
    }

    public static IoFuture.Notifier<Closeable, Void> closingNotifier() {
        return CLOSING_NOTIFIER;
    }

    public static <T> IoFuture.Notifier<T, Void> runnableNotifier(final Runnable runnable) {
        return new IoFuture.Notifier<T, Void>(){

            @Override
            public void notify(IoFuture<? extends T> future, Void attachment) {
                runnable.run();
            }
        };
    }

    public static <T> Future<T> getFuture(final IoFuture<T> ioFuture) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                ioFuture.cancel();
                return ioFuture.await() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isCancelled() {
                return ioFuture.getStatus() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isDone() {
                return ioFuture.getStatus() == IoFuture.Status.DONE;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                try {
                    return ioFuture.getInterruptibly();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    if (ioFuture.awaitInterruptibly(timeout, unit) == IoFuture.Status.WAITING) {
                        throw new TimeoutException("Operation timed out");
                    }
                    return ioFuture.getInterruptibly();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }

            public String toString() {
                return String.format("java.util.concurrent.Future wrapper <%s> for %s", Integer.toHexString(this.hashCode()), ioFuture);
            }
        };
    }

    /*
     * Exception decompiling
     */
    public static void awaitAll(IoFuture<?> ... futures) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void awaitAllInterruptibly(IoFuture<?> ... futures) throws InterruptedException {
        int len = futures.length;
        CountDownLatch cdl = new CountDownLatch(len);
        IoFuture<?>[] ioFutureArray = futures;
        int n = futures.length;
        int n2 = 0;
        while (n2 < n) {
            IoFuture<?> future = ioFutureArray[n2];
            future.addNotifier(COUNT_DOWN_NOTIFIER, cdl);
            ++n2;
        }
        cdl.await();
    }

    public static <I, O> IoFuture<? extends O> cast(IoFuture<I> parent, Class<O> type) {
        return new CastingIoFuture(parent, type);
    }

    public static <T extends Channel> boolean invokeChannelListener(T channel, ChannelListener<? super T> channelListener) {
        if (channelListener != null) {
            try {
                channelListener.handleEvent(channel);
            }
            catch (Throwable t) {
                listenerLog.error(t, "A channel event listener threw an exception", new Object[0]);
                return false;
            }
        }
        return true;
    }

    public static ChannelListener<Channel> closingChannelListener() {
        return CLOSING_CHANNEL_LISTENER;
    }

    public static <T extends Channel, C> ChannelListener.Setter<T> getSetter(final C channel, final AtomicReferenceFieldUpdater<C, ChannelListener> updater) {
        return new ChannelListener.Setter<T>(){

            @Override
            public void set(ChannelListener<? super T> channelListener) {
                updater.set(channel, channelListener);
            }
        };
    }

    private static class CastingIoFuture<O, I>
    implements IoFuture<O> {
        private final IoFuture<I> parent;
        private final Class<O> type;

        private CastingIoFuture(IoFuture<I> parent, Class<O> type) {
            this.parent = parent;
            this.type = type;
        }

        @Override
        public IoFuture<O> cancel() {
            this.parent.cancel();
            return this;
        }

        @Override
        public IoFuture.Status getStatus() {
            return this.parent.getStatus();
        }

        @Override
        public IoFuture.Status await() {
            return this.parent.await();
        }

        @Override
        public IoFuture.Status await(long time, TimeUnit timeUnit) {
            return this.parent.await(time, timeUnit);
        }

        @Override
        public IoFuture.Status awaitInterruptibly() throws InterruptedException {
            return this.parent.awaitInterruptibly();
        }

        @Override
        public IoFuture.Status awaitInterruptibly(long time, TimeUnit timeUnit) throws InterruptedException {
            return this.parent.awaitInterruptibly(time, timeUnit);
        }

        @Override
        public O get() throws IOException, CancellationException {
            return this.type.cast(this.parent.get());
        }

        @Override
        public O getInterruptibly() throws IOException, InterruptedException, CancellationException {
            return this.type.cast(this.parent.getInterruptibly());
        }

        @Override
        public IOException getException() throws IllegalStateException {
            return this.parent.getException();
        }

        @Override
        public <A> IoFuture<O> addNotifier(final IoFuture.Notifier<? super O, A> notifier, A attachment) {
            this.parent.addNotifier(new IoFuture.Notifier<I, A>(){

                @Override
                public void notify(IoFuture<? extends I> future, A attachment) {
                    notifier.notify(CastingIoFuture.this, attachment);
                }
            }, attachment);
            return this;
        }
    }
}

