/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;

public final class FlagSet<E extends Enum<E>>
extends AbstractSet<E>
implements Serializable {
    private final Class<E> type;
    private final EnumSet<E> values;
    private static final long serialVersionUID = 4155828678034140336L;

    private FlagSet(Class<E> type, EnumSet<E> values) {
        this.type = type;
        this.values = values;
    }

    public static <E extends Enum<E>> FlagSet<E> copyOf(Class<E> elementType, Collection<E> original) {
        return new FlagSet<E>(elementType, EnumSet.copyOf(original));
    }

    public static <E extends Enum<E>> FlagSet<E> noneOf(Class<E> elementType) {
        return new FlagSet<E>(elementType, EnumSet.noneOf(elementType));
    }

    public static <E extends Enum<E>> FlagSet<E> allOf(Class<E> elementType) {
        return new FlagSet<E>(elementType, EnumSet.allOf(elementType));
    }

    public static <E extends Enum<E>> FlagSet<E> of(E ... elements) {
        if (elements.length == 0) {
            throw new IllegalArgumentException("Empty elements array");
        }
        Class<?> elementType = elements[0].getClass();
        while (elementType.getSuperclass() != Enum.class) {
            elementType = elementType.getSuperclass();
        }
        return new FlagSet<E[]>(elementType, EnumSet.of(elements[0], elements));
    }

    public Class<E> getElementType() {
        return this.type;
    }

    public <N extends Enum<N>> FlagSet<N> cast(Class<N> type) throws ClassCastException {
        this.type.asSubclass(type);
        return this;
    }

    @Override
    public boolean contains(Object o) {
        return this.values.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableSet(this.values).iterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }
}

