/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ws.api.Messages;
import org.jboss.ws.api.util.SecurityActions;

public final class ServiceLoader {
    private static Map<ClassLoader, Map<String, String>> serviceMap = Collections.synchronizedMap(new WeakHashMap());

    private ServiceLoader() {
    }

    public static Object loadService(String propertyName, String defaultFactory, ClassLoader cl) {
        Object factory = ServiceLoader.loadFromServices(propertyName, cl);
        if (factory == null) {
            factory = ServiceLoader.loadFromSystemProperty(propertyName, defaultFactory, cl);
        }
        return factory;
    }

    public static Object loadService(String propertyName, String defaultFactory) {
        return ServiceLoader.loadService(propertyName, defaultFactory, SecurityActions.getContextClassLoader());
    }

    private static Object loadFromServices(String propertyName, ClassLoader loader) {
        Object factory = null;
        String factoryName = null;
        String filename = "META-INF/services/" + propertyName;
        try {
            factoryName = ServiceLoader.getServiceNameUsingCache(loader, filename);
            if (factoryName != null) {
                Class<?> factoryClass = SecurityActions.loadClass(loader, factoryName);
                factory = factoryClass.newInstance();
            }
        }
        catch (Throwable t) {
            throw Messages.MESSAGES.failedToLoad(t, new Object[]{propertyName, factoryName});
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getServiceNameUsingCache(ClassLoader loader, String filename) throws IOException {
        Map<String, String> map;
        Map<ClassLoader, Map<String, String>> map2 = serviceMap;
        synchronized (map2) {
            map = serviceMap.get(loader);
            if (map == null) {
                map = new ConcurrentHashMap<String, String>();
                serviceMap.put(loader, map);
            }
        }
        String factoryName = map.get(filename);
        if (factoryName != null) {
            return factoryName;
        }
        InputStream inStream = SecurityActions.getResourceAsStream(loader, filename);
        if (inStream != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
            factoryName = br.readLine();
            br.close();
            map.put(filename, factoryName);
        }
        return factoryName;
    }

    private static Object loadFromSystemProperty(String propertyName, String defaultFactory, ClassLoader loader) {
        Object factory = null;
        PropertyAccessAction action = new PropertyAccessAction(propertyName);
        String factoryName = AccessController.doPrivileged(action);
        if (factoryName != null) {
            try {
                factory = SecurityActions.loadClass(loader, factoryName).newInstance();
            }
            catch (Throwable t) {
                throw Messages.MESSAGES.failedToLoad(t, new Object[]{propertyName, factoryName});
            }
        }
        if (factory == null && defaultFactory != null) {
            factory = ServiceLoader.loadDefault(defaultFactory, loader);
        }
        return factory;
    }

    private static Object loadDefault(String defaultFactory, ClassLoader loader) {
        Object factory;
        try {
            factory = SecurityActions.loadClass(loader, defaultFactory).newInstance();
        }
        catch (Throwable t) {
            throw Messages.MESSAGES.failedToLoad(t, defaultFactory);
        }
        return factory;
    }

    private static class PropertyAccessAction
    implements PrivilegedAction<String> {
        private final String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        @Override
        public String run() {
            return System.getProperty(this.name);
        }
    }
}

