/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5;

import java.util.List;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.junit5.WeldInitiator;
import org.jboss.weld.junit5.WeldJunit5Extension;
import org.jboss.weld.junit5.WeldJunitEnricher;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ExtensionContextUtils {
    private static final String INITIATOR = "weldInitiator";
    private static final String CONTAINER = "weldContainer";
    private static final String EXPLICIT_PARAM_INJECTION = "explicitParamInjection";
    private static final String WELD_ENRICHERS = "weldEnrichers";
    private static ExtensionContext.Namespace EXTENSION_NAMESPACE;

    private ExtensionContextUtils() {
    }

    private static synchronized ExtensionContext.Store getRootExtensionStore(ExtensionContext context) {
        if (EXTENSION_NAMESPACE == null) {
            EXTENSION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{WeldJunit5Extension.class});
        }
        return context.getRoot().getStore(EXTENSION_NAMESPACE);
    }

    private static ExtensionContext.Store getTestStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{WeldJunit5Extension.class, context.getRequiredTestClass()}));
    }

    public static WeldInitiator getInitiatorFromStore(ExtensionContext context) {
        return (WeldInitiator)((Object)ExtensionContextUtils.getTestStore(context).get((Object)INITIATOR, WeldInitiator.class));
    }

    public static void setInitiatorToStore(ExtensionContext context, WeldInitiator initiator) {
        ExtensionContextUtils.getTestStore(context).put((Object)INITIATOR, (Object)initiator);
    }

    public static Boolean getExplicitInjectionInfoFromStore(ExtensionContext context) {
        Boolean result = (Boolean)ExtensionContextUtils.getTestStore(context).get((Object)EXPLICIT_PARAM_INJECTION, Boolean.class);
        return result == null ? Boolean.FALSE : result;
    }

    public static void setExplicitInjectionInfoToStore(ExtensionContext context, boolean value) {
        ExtensionContextUtils.getTestStore(context).put((Object)EXPLICIT_PARAM_INJECTION, (Object)value);
    }

    public static WeldContainer getContainerFromStore(ExtensionContext context) {
        return (WeldContainer)ExtensionContextUtils.getTestStore(context).get((Object)CONTAINER, WeldContainer.class);
    }

    public static void setContainerToStore(ExtensionContext context, WeldContainer container) {
        ExtensionContextUtils.getTestStore(context).put((Object)CONTAINER, (Object)container);
    }

    public static List<WeldJunitEnricher> getEnrichersFromStore(ExtensionContext context) {
        List enrichers = (List)ExtensionContextUtils.getRootExtensionStore(context).get((Object)WELD_ENRICHERS, List.class);
        return enrichers;
    }

    public static void setEnrichersToStore(ExtensionContext context, List<WeldJunitEnricher> enrichers) {
        ExtensionContextUtils.getRootExtensionStore(context).put((Object)WELD_ENRICHERS, enrichers);
    }
}

