/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5.auto;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.decorator.Decorator;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.interceptor.Interceptor;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.junit5.auto.AddBeanClasses;
import org.jboss.weld.junit5.auto.AddEnabledDecorators;
import org.jboss.weld.junit5.auto.AddEnabledInterceptors;
import org.jboss.weld.junit5.auto.AddExtensions;
import org.jboss.weld.junit5.auto.AddPackages;
import org.jboss.weld.junit5.auto.EnableAlternativeStereotypes;
import org.jboss.weld.junit5.auto.EnableAlternatives;
import org.jboss.weld.junit5.auto.ExcludeBean;
import org.jboss.weld.junit5.auto.ExcludeBeanClasses;
import org.jboss.weld.junit5.auto.ExcludedBeansExtension;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;

class ClassScanning {
    ClassScanning() {
    }

    static void scanForRequiredBeanClasses(List<Class<?>> testClasses, Weld weld, boolean explicitInjection) {
        ArrayList classesToProcess = new ArrayList();
        classesToProcess.addAll(testClasses);
        HashSet<Class> foundClasses = new HashSet<Class>();
        HashSet<Type> excludedBeanTypes = new HashSet<Type>();
        HashSet excludedBeanClasses = new HashSet();
        while (!classesToProcess.isEmpty()) {
            Class currClass = (Class)classesToProcess.remove(0);
            if (foundClasses.contains(currClass) || excludedBeanTypes.contains(currClass) || excludedBeanClasses.contains(currClass) || currClass.isPrimitive() || currClass.isSynthetic() || currClass.getName().startsWith("java") || currClass.getName().startsWith("sun")) continue;
            foundClasses.add(currClass);
            AnnotationSupport.findAnnotatedFields((Class)currClass, ExcludeBean.class).stream().map(Field::getType).forEach(excludedBeanTypes::add);
            AnnotationSupport.findAnnotatedMethods((Class)currClass, ExcludeBean.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().map(Method::getReturnType).forEach(excludedBeanTypes::add);
            AnnotationSupport.findAnnotatedFields((Class)currClass, Inject.class).stream().map(ClassScanning::unwrapInstanceTypeParameter).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, Inject.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().map(Method::getReturnType).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            ClassScanning.findFirstAnnotatedConstructor(currClass, Inject.class).map(Stream::of).orElseGet(Stream::empty).flatMap(cons -> ClassScanning.getExecutableParameterTypes(cons, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            ClassScanning.findAnnotatedDeclaredFields(currClass, Produces.class).stream().map(Field::getType).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            ClassScanning.findAnnotatedDeclaredMethods(currClass, Produces.class).stream().flatMap(method -> Stream.concat(ClassScanning.getExecutableParameterTypes(method, explicitInjection).stream(), Stream.of(method.getReturnType()))).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, Test.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, RepeatedTest.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, BeforeAll.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, BeforeEach.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, AfterEach.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, AfterAll.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddPackages.class).forEach(ann -> Arrays.stream(ann.value()).distinct().forEach(cls -> weld.addPackage(ann.recursively(), cls)));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddBeanClasses.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(it -> {
                classesToProcess.add((Class<?>)it);
                weld.addBeanClass(it);
            });
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddExtensions.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().map(ClassScanning::createExtension).forEach(arg_0 -> ((Weld)weld).addExtension(arg_0));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddEnabledInterceptors.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(interceptor -> {
                classesToProcess.add((Class<?>)interceptor);
                weld.addInterceptor(interceptor);
                weld.addBeanClass(interceptor);
            });
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddEnabledDecorators.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(decorator -> {
                classesToProcess.add((Class<?>)decorator);
                weld.addDecorator(decorator);
                weld.addBeanClass(decorator);
            });
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, EnableAlternatives.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(arg_0 -> ((Weld)weld).addAlternative(arg_0));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, EnableAlternativeStereotypes.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(arg_0 -> ((Weld)weld).addAlternativeStereotype(arg_0));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, ExcludeBeanClasses.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(excludedBeanClasses::add);
        }
        for (Class foundClass : foundClasses) {
            if (!ClassScanning.hasBeanDefiningAnnotation(foundClass)) continue;
            weld.addBeanClass(foundClass);
        }
        weld.addExtension((Extension)new ExcludedBeansExtension(excludedBeanTypes, excludedBeanClasses));
    }

    private static void addClassesToProcess(Collection<Class<?>> classesToProcess, Type type) {
        if (type instanceof Class) {
            classesToProcess.add((Class)type);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            classesToProcess.add((Class)ptype.getRawType());
            for (Type arg : ptype.getActualTypeArguments()) {
                ClassScanning.addClassesToProcess(classesToProcess, arg);
            }
        }
    }

    private static List<Class<?>> getExecutableParameterTypes(Executable executable, boolean explicitInjection) {
        ArrayList types = new ArrayList();
        if (explicitInjection) {
            Annotation[][] paramAnns = executable.getParameterAnnotations();
            Class<?>[] paramTypes = executable.getParameterTypes();
            for (int c = 0; c < paramTypes.length; ++c) {
                if (!Arrays.stream(paramAnns[c]).anyMatch(ClassScanning::isBeanParameterAnnotation)) continue;
                types.add(paramTypes[c]);
            }
        } else {
            types.addAll(Arrays.asList(executable.getParameterTypes()));
        }
        return types;
    }

    private static Extension createExtension(Class<? extends Extension> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isBeanParameterAnnotation(Annotation ann) {
        return AnnotationSupport.isAnnotated(ann.annotationType(), Qualifier.class);
    }

    private static boolean hasBeanDefiningAnnotation(Class<?> clazz) {
        return AnnotationSupport.isAnnotated(clazz, NormalScope.class) || AnnotationSupport.isAnnotated(clazz, Dependent.class) || AnnotationSupport.isAnnotated(clazz, Interceptor.class) || AnnotationSupport.isAnnotated(clazz, Decorator.class) || AnnotationSupport.isAnnotated(clazz, Stereotype.class);
    }

    private static List<Field> findAllFieldsInHierarchy(Class<?> clazz) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        List localFields = ClassScanning.getDeclaredFields(clazz).stream().filter(field -> !field.isSynthetic()).collect(Collectors.toList());
        List superclassFields = ClassScanning.getSuperclassFields(clazz).stream().filter(field -> !ClassScanning.isMethodShadowedByLocalFields(field, localFields)).collect(Collectors.toList());
        ArrayList<Field> methods = new ArrayList<Field>();
        methods.addAll(superclassFields);
        methods.addAll(localFields);
        return methods;
    }

    private static List<Field> getSuperclassFields(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        return superclass != null && superclass != Object.class ? ClassScanning.findAllFieldsInHierarchy(superclass) : Collections.emptyList();
    }

    private static List<Field> getDeclaredFields(Class<?> clazz) {
        return Arrays.asList(clazz.getDeclaredFields());
    }

    private static List<Method> getDeclaredMethods(Class<?> clazz) {
        return Arrays.asList(clazz.getDeclaredMethods());
    }

    private static boolean isMethodShadowedByLocalFields(Field field, List<Field> localFields) {
        return localFields.stream().anyMatch(local -> ClassScanning.isFieldShadowedBy(field, local));
    }

    private static boolean isFieldShadowedBy(Field upper, Field lower) {
        return upper.getType().equals(lower.getType());
    }

    private static List<Field> findAnnotatedDeclaredFields(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return (List)ClassScanning.getDeclaredFields(clazz).stream().filter(field -> AnnotationSupport.isAnnotated((AnnotatedElement)field, (Class)annotationType)).collect(CollectionUtils.toUnmodifiableList());
    }

    private static List<Method> findAnnotatedDeclaredMethods(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return (List)ClassScanning.getDeclaredMethods(clazz).stream().filter(field -> AnnotationSupport.isAnnotated((AnnotatedElement)field, (Class)annotationType)).collect(CollectionUtils.toUnmodifiableList());
    }

    private static List<Constructor<?>> getDeclaredConstructors(Class<?> clazz) {
        return Arrays.asList(clazz.getDeclaredConstructors());
    }

    private static Optional<Constructor<?>> findFirstAnnotatedConstructor(Class<?> clazz, Class<? extends Annotation> annotationType) {
        Optional<Constructor<?>> found = ClassScanning.getDeclaredConstructors(clazz).stream().filter(cons -> AnnotationSupport.isAnnotated((AnnotatedElement)cons, (Class)annotationType)).findFirst();
        if (found.isPresent() || clazz.getSuperclass() == null) {
            return found;
        }
        return ClassScanning.findFirstAnnotatedConstructor(clazz.getSuperclass(), annotationType);
    }

    private static Class<?> unwrapInstanceTypeParameter(Field field) {
        Class type = field.getType();
        if (type.equals(Instance.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type typeParameter = parameterizedType.getActualTypeArguments()[0];
            type = typeParameter instanceof ParameterizedType ? (Class)((ParameterizedType)typeParameter).getRawType() : (Class)typeParameter;
        }
        return type;
    }
}

