/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5.auto;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.inject.Scope;

public class ExcludedBeansExtension
implements Extension {
    private Set<Type> excludedBeanTypes;
    private Set<Class<?>> excludedBeanClasses;

    ExcludedBeansExtension(Set<Type> excludedBeanTypes, Set<Class<?>> excludedBeanClasses) {
        this.excludedBeanTypes = excludedBeanTypes;
        this.excludedBeanClasses = excludedBeanClasses;
    }

    <T> void excludeBeans(@Observes @WithAnnotations(value={Scope.class, NormalScope.class}) ProcessAnnotatedType<T> pat) {
        if (this.excludedBeanClasses.contains(pat.getAnnotatedType().getJavaClass())) {
            pat.veto();
            return;
        }
        Set typeClosure = pat.getAnnotatedType().getTypeClosure();
        for (Type excludedBeanType : this.excludedBeanTypes) {
            if (!typeClosure.contains(excludedBeanType)) continue;
            pat.veto();
            return;
        }
    }
}

