/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit4;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.junit.AbstractWeldInitiator;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class WeldInitiator
extends AbstractWeldInitiator
implements TestRule {
    public static WeldInitiator of(Class<?> ... beanClasses) {
        return (WeldInitiator)WeldInitiator.from(beanClasses).build();
    }

    public static WeldInitiator of(Weld weld) {
        return (WeldInitiator)WeldInitiator.from(weld).build();
    }

    public static WeldInitiator ofTestPackage() {
        return (WeldInitiator)WeldInitiator.fromTestPackage().build();
    }

    public static WeldInitiator performDefaultDiscovery() {
        return WeldInitiator.of(new Weld());
    }

    public static Builder from(Class<?> ... beanClasses) {
        Weld weld = WeldInitiator.createWeld();
        for (Class<?> clazz : beanClasses) {
            if (Extension.class.isAssignableFrom(clazz)) {
                weld.addExtensions(new Class[]{clazz});
                continue;
            }
            weld.addBeanClass(clazz);
        }
        return WeldInitiator.from(weld);
    }

    public static Builder from(Weld weld) {
        return new Builder(weld);
    }

    public static Builder fromTestPackage() {
        return new Builder(null);
    }

    public static Weld createWeld() {
        return AbstractWeldInitiator.createWeld();
    }

    private WeldInitiator(Weld weld, List<Object> instancesToInject, Set<Class<? extends Annotation>> scopesToActivate, Set<Bean<?>> beans, Map<String, Object> resources, Function<InjectionPoint, Object> ejbFactory, Function<InjectionPoint, Object> persistenceUnitFactory, Function<InjectionPoint, Object> persistenceContextFactory) {
        super(weld, instancesToInject, scopesToActivate, beans, resources, ejbFactory, persistenceUnitFactory, persistenceContextFactory);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Weld weld = WeldInitiator.this.weld;
                if (weld == null) {
                    weld = WeldInitiator.createWeld().addPackage(false, description.getTestClass());
                }
                WeldInitiator.this.initWeldContainer(weld);
                try {
                    base.evaluate();
                }
                finally {
                    WeldInitiator.this.shutdownWeldContainer();
                }
            }
        };
    }

    public static final class Builder
    extends AbstractWeldInitiator.AbstractBuilder<WeldInitiator, Builder> {
        private Builder(Weld weld) {
            super(weld);
        }

        protected Builder self() {
            return this;
        }

        protected WeldInitiator build(Weld weld, List<Object> instancesToInject, Set<Class<? extends Annotation>> scopesToActivate, Set<Bean<?>> beans) {
            return new WeldInitiator(weld, instancesToInject, scopesToActivate, beans, this.resources, this.getEjbFactory(), this.getPersistenceUnitFactory(), this.getPersistenceContextFactory());
        }
    }
}

