/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Unmanaged;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.junit.MockBeanWithPriority;
import org.jboss.weld.junit.WeldCDIExtension;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

public class MockBean<T>
implements Bean<T>,
PassivationCapable {
    private static final AtomicInteger SEQUENCE = new AtomicInteger(0);
    private final Set<Class<? extends Annotation>> stereotypes;
    private final boolean alternative;
    private final boolean selectForSyntheticBeanArchive;
    private final String name;
    private final Set<Annotation> qualifiers;
    private final Set<Type> types;
    private final Class<? extends Annotation> scope;
    private final CreateFunction<T> createCallback;
    private final DestroyFunction<T> destroyCallback;
    private final String id;
    private final Class<?> beanClass;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Bean<T> of(T beanInstance, Type ... beanTypes) {
        return MockBean.builder().types(beanTypes).creating(beanInstance).build();
    }

    public static <T> Builder<T> read(Class<T> beanClass) {
        return MockBean.readInternal(beanClass).useUnmanaged(beanClass);
    }

    protected MockBean(Class<?> beanClass, Set<Class<? extends Annotation>> stereotypes, boolean alternative, boolean selectForSyntheticBeanArchive, String name, Set<Annotation> qualifiers, Set<Type> types, Class<? extends Annotation> scope, CreateFunction<T> createCallback, DestroyFunction<T> destroyCallback) {
        this.beanClass = beanClass;
        this.stereotypes = stereotypes;
        this.alternative = alternative;
        this.selectForSyntheticBeanArchive = selectForSyntheticBeanArchive;
        this.name = name;
        this.qualifiers = qualifiers;
        this.types = types;
        this.scope = scope;
        this.createCallback = createCallback;
        this.destroyCallback = destroyCallback;
        this.id = MockBean.class.getName() + "_" + SEQUENCE.incrementAndGet();
    }

    public T create(CreationalContext<T> creationalContext) {
        return this.createCallback.create(creationalContext);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (this.destroyCallback != null) {
            this.destroyCallback.destroy(instance, creationalContext);
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    boolean isSelectForSyntheticBeanArchive() {
        return this.selectForSyntheticBeanArchive;
    }

    public String getId() {
        return this.id;
    }

    private static <T> Builder<T> readInternal(Class<T> beanClass) {
        Builder builder = new Builder().beanClass(beanClass);
        Set<Annotation> stereotypes = MockBean.getStereotypes(beanClass);
        Named named = beanClass.getAnnotation(Named.class);
        if (named != null) {
            if ("".equals(named.value())) {
                builder.name(MockBean.getDefaultName(beanClass));
            } else {
                builder.name(named.value());
            }
        } else {
            for (Annotation stereotype : stereotypes) {
                if (!stereotype.annotationType().isAnnotationPresent(Named.class)) continue;
                builder.name(MockBean.getDefaultName(beanClass));
                break;
            }
        }
        Set<Annotation> scopes = MockBean.getScopes(beanClass);
        if (scopes.isEmpty()) {
            for (Annotation stereotype : stereotypes) {
                scopes.addAll(MockBean.getScopes(stereotype.annotationType()));
            }
        }
        if (!scopes.isEmpty()) {
            if (scopes.size() > 1) {
                throw new IllegalStateException("At most one scope may be specifie [beanClass: " + beanClass + ", scopes: " + scopes + "]");
            }
            builder.scope(scopes.iterator().next().annotationType());
        }
        builder.types(new HierarchyDiscovery(beanClass).getTypeClosure());
        for (Annotation annotation : beanClass.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            builder.addQualifier(annotation);
        }
        if (beanClass.isAnnotationPresent(Alternative.class)) {
            builder.alternative(true);
        } else {
            for (Annotation stereotype : stereotypes) {
                if (!stereotype.annotationType().isAnnotationPresent(Alternative.class)) continue;
                builder.alternative(true);
                break;
            }
        }
        return builder;
    }

    private static Set<Annotation> getStereotypes(AnnotatedElement element) {
        HashSet<Annotation> stereotypes = new HashSet<Annotation>();
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Stereotype.class)) continue;
            stereotypes.add(annotation);
            stereotypes.addAll(MockBean.getStereotypes(annotation.annotationType()));
        }
        return stereotypes;
    }

    private static Set<Annotation> getScopes(AnnotatedElement element) {
        HashSet<Annotation> scopes = new HashSet<Annotation>();
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Scope.class) && !annotation.annotationType().isAnnotationPresent(NormalScope.class)) continue;
            scopes.add(annotation);
        }
        return scopes;
    }

    private static String getDefaultName(Class<?> beanClass) {
        StringBuilder defaultName = new StringBuilder(beanClass.getSimpleName());
        defaultName.setCharAt(0, Character.toLowerCase(beanClass.getSimpleName().charAt(0)));
        return defaultName.toString();
    }

    static class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = -1395539980812895226L;
        public static final Default INSTANCE = new DefaultLiteral();

        private DefaultLiteral() {
        }
    }

    static class AnyLiteral
    extends AnnotationLiteral<Any>
    implements Any {
        private static final long serialVersionUID = -1366513826361712883L;
        public static final Any INSTANCE = new AnyLiteral();

        private AnyLiteral() {
        }
    }

    public static interface DestroyFunction<T> {
        public void destroy(T var1, CreationalContext<T> var2);
    }

    public static interface CreateFunction<T> {
        public T create(CreationalContext<T> var1);
    }

    public static class Builder<T> {
        private Class<?> beanClass;
        private Set<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
        private boolean alternative = false;
        private boolean selectForSyntheticBeanArchive;
        private Integer priority;
        private String name;
        private Set<Annotation> qualifiers = new HashSet<Annotation>();
        private Set<Type> types;
        private Class<? extends Annotation> scope;
        private CreateFunction<T> createCallback;
        private DestroyFunction<T> destroyCallback;

        private Builder() {
            this.qualifiers.add((Annotation)AnyLiteral.INSTANCE);
            this.scope = Dependent.class;
            this.types = new HashSet<Type>();
            this.types.add((Type)((Object)Object.class));
            this.beanClass = WeldCDIExtension.class;
            this.priority = null;
        }

        public Builder<T> beanClass(Class<?> beanClass) {
            this.beanClass = beanClass;
            return this;
        }

        public Builder<T> scope(Class<? extends Annotation> scope) {
            this.scope = scope;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> types(Type ... types) {
            this.types.clear();
            Collections.addAll(this.types, types);
            return this;
        }

        public Builder<T> types(Set<Type> types) {
            this.types.clear();
            this.types.addAll(types);
            return this;
        }

        public Builder<T> addType(Type type) {
            this.types.add(type);
            return this;
        }

        public Builder<T> qualifiers(Annotation ... qualifiers) {
            this.qualifiers.clear();
            Collections.addAll(this.qualifiers, qualifiers);
            return this;
        }

        public Builder<T> addQualifier(Annotation qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        public Builder<T> alternative(boolean value) {
            this.alternative = value;
            return this;
        }

        public Builder<T> priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder<T> globallySelectedAlternative(int priority) {
            this.priority = priority;
            this.alternative = true;
            return this;
        }

        public Builder<T> selectedAlternative() {
            this.alternative(true);
            this.selectForSyntheticBeanArchive = true;
            return this;
        }

        public Builder<T> selectedAlternative(Class<?> beanClass) {
            this.selectedAlternative();
            this.beanClass(beanClass);
            return this;
        }

        public Builder<T> stereotypes(Class<? extends Annotation> ... stereotypes) {
            this.stereotypes.clear();
            Collections.addAll(this.stereotypes, stereotypes);
            return this;
        }

        public Builder<T> addStereotype(Class<? extends Annotation> stereotype) {
            this.stereotypes.add(stereotype);
            return this;
        }

        public Builder<T> creating(T instance) {
            this.createCallback = ctx -> instance;
            return this;
        }

        public Builder<T> useUnmanaged(Class<T> beanClass) {
            ConcurrentHashMap ctxToUnmanaged = new ConcurrentHashMap();
            this.create(ctx -> {
                Unmanaged unmanaged = new Unmanaged(WeldContainer.current().getBeanManager(), beanClass);
                Unmanaged.UnmanagedInstance unmanagedInstance = unmanaged.newInstance();
                ctxToUnmanaged.put(ctx.toString(), unmanagedInstance);
                return unmanagedInstance.produce().inject().postConstruct().get();
            });
            this.destroy((o, ctx) -> {
                Unmanaged.UnmanagedInstance unmanagedInstance = (Unmanaged.UnmanagedInstance)ctxToUnmanaged.remove(ctx.toString());
                if (unmanagedInstance != null) {
                    if (!unmanagedInstance.get().equals(o)) {
                        throw new IllegalStateException("Unmanaged instance [" + unmanagedInstance.get() + "] is not equal to the bean instance to be destroyed: " + o);
                    }
                    unmanagedInstance.preDestroy().dispose();
                }
            });
            return this;
        }

        public Builder<T> create(CreateFunction<T> callback) {
            this.createCallback = callback;
            return this;
        }

        public Builder<T> destroy(DestroyFunction<T> callback) {
            this.destroyCallback = callback;
            return this;
        }

        public MockBean<T> build() {
            if (this.createCallback == null) {
                throw new IllegalStateException("Create callback must not be null");
            }
            Set<Annotation> normalizedQualfiers = new HashSet<Annotation>(this.qualifiers);
            normalizedQualfiers.remove(Any.Literal.INSTANCE);
            normalizedQualfiers.remove(Default.Literal.INSTANCE);
            if (normalizedQualfiers.isEmpty()) {
                normalizedQualfiers.add((Annotation)Default.Literal.INSTANCE);
                normalizedQualfiers.add((Annotation)Any.Literal.INSTANCE);
            } else {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                if (normalizedQualfiers.size() == 1 && ((Annotation)normalizedQualfiers.iterator().next()).annotationType().equals(Named.class)) {
                    builder.add((Object)Default.Literal.INSTANCE);
                }
                builder.add((Object)Any.Literal.INSTANCE);
                builder.addAll(this.qualifiers);
                normalizedQualfiers = builder.build();
            }
            if (this.priority != null) {
                return new MockBeanWithPriority<T>(this.beanClass, this.stereotypes, this.alternative, this.selectForSyntheticBeanArchive, this.priority, this.name, normalizedQualfiers, this.types, this.scope, this.createCallback, this.destroyCallback);
            }
            return new MockBean<T>(this.beanClass, this.stereotypes, this.alternative, this.selectForSyntheticBeanArchive, this.name, normalizedQualfiers, this.types, this.scope, this.createCallback, this.destroyCallback);
        }
    }
}

