/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;

class ContextImpl
implements Context {
    private static final Logger LOGGER = Logger.getLogger(ContextImpl.class.getName());
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    private final ThreadLocal<Map<Contextual<?>, ContextualInstance<?>>> currentContext = new ThreadLocal();

    ContextImpl(Class<? extends Annotation> scope, BeanManager beanManager) {
        this.scope = scope;
        this.beanManager = beanManager;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            throw new ContextNotActiveException();
        }
        ContextualInstance<Object> instance = ctx.get(contextual);
        if (instance == null && creationalContext != null) {
            instance = new ContextualInstance<Object>(contextual.create(creationalContext), creationalContext, contextual);
            ctx.put(contextual, instance);
        }
        return instance != null ? (T)instance.get() : null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return this.currentContext.get() != null;
    }

    public void destroy(Contextual<?> contextual) {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            return;
        }
        ctx.remove(contextual);
    }

    public void activate() {
        this.currentContext.set(new HashMap());
        this.beanManager.fireEvent(new Object(), new Annotation[]{Initialized.Literal.of(this.scope)});
    }

    public void deactivate() {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            return;
        }
        for (ContextualInstance<?> instance : ctx.values()) {
            try {
                instance.destroy();
            }
            catch (Exception e) {
                LOGGER.warning("Unable to destroy instance" + instance.get() + " for bean: " + instance.getContextual());
            }
        }
        ctx.clear();
        this.currentContext.remove();
        this.beanManager.fireEvent(new Object(), new Annotation[]{Destroyed.Literal.of(this.scope)});
    }

    static final class ContextualInstance<T> {
        private final T value;
        private final CreationalContext<T> creationalContext;
        private final Contextual<T> contextual;

        ContextualInstance(T instance, CreationalContext<T> creationalContext, Contextual<T> contextual) {
            this.value = instance;
            this.creationalContext = creationalContext;
            this.contextual = contextual;
        }

        T get() {
            return this.value;
        }

        Contextual<T> getContextual() {
            return this.contextual;
        }

        void destroy() {
            this.contextual.destroy(this.value, this.creationalContext);
        }
    }
}

