/*
 * JBoss, Home of Professional Open Source
 * Copyright 2015, Red Hat, Inc. and/or its affiliates, and individual
 * contributors by the @authors tag. See the copyright.txt in the
 * distribution for a full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletContext;

import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.jandex.Jandex;
import org.jboss.weld.environment.logging.CommonLogger;

/**
 * @author Tomas Remes
 */
public class JandexServletContextBeanArchiveHandler extends ServletContextBeanArchiveHandler {

    private final Indexer indexer = new Indexer();

    private final ServletContext servletContext;

    /**
     * @param servletContext
     */
    public JandexServletContextBeanArchiveHandler(ServletContext servletContext) {
        super(servletContext);
        this.servletContext = servletContext;
    }

    @Override
    public BeanArchiveBuilder handle(String path) {
        BeanArchiveBuilder builder = super.handle(path);
        if (builder == null) {
            return null;
        }

        builder.setAttribute(Jandex.INDEX_ATTRIBUTE_NAME, buildIndex());
        return builder;
    }

    private void addToIndex(InputStream inputStream) {
        try {
            indexer.index(inputStream);
        } catch (IOException ex) {
            CommonLogger.LOG.couldNotOpenStreamForURL(inputStream, ex);
        }
    }

    @Override
    protected void add(String rootPath, String subpath, BeanArchiveBuilder builder) {
        super.add(rootPath, subpath, builder);
        addToIndex(servletContext.getResourceAsStream(subpath));
    }

    private Index buildIndex() {
        return indexer.complete();
    }
}
