/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.collections.WeldCollections;

public abstract class AbstractBuiltInBean<T>
extends RIBean<T> {
    private static final String ID_PREFIX = "Built-in";
    private boolean proxyRequired;
    private final Class<T> type;

    protected AbstractBuiltInBean(String idSuffix, BeanManagerImpl beanManager, Class<T> type) {
        super(new BuiltInBeanAttributes<T>(type), ID_PREFIX + "-" + idSuffix, beanManager);
        this.type = type;
    }

    @Override
    public void preInitialize() {
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        this.proxyRequired = this.getScope() != null && this.isNormalScoped();
    }

    @Override
    public void cleanupAfterBoot() {
    }

    @Override
    public void initializeAfterBeanDiscovery() {
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public boolean isProxyable() {
        return true;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return true;
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return true;
    }

    @Override
    public boolean isProxyRequired() {
        return this.proxyRequired;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    protected static class BuiltInBeanAttributes<T>
    extends ImmutableBeanAttributes<T> {
        private static final Set<Annotation> DEFAULT_QUALIFIERS = Arrays2.asSet(DefaultLiteral.INSTANCE, AnyLiteral.INSTANCE);

        public BuiltInBeanAttributes(Class<T> type) {
            super(Collections.<Class<Annotation>>emptySet(), false, null, DEFAULT_QUALIFIERS, WeldCollections.immutableSet(Sets.newHashSet(type, Object.class)), Dependent.class);
        }
    }
}

