/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.util.Observers;

public class ResolvedObservers<T> {
    private static final ResolvedObservers<Object> EMPTY = new ResolvedObservers<Object>(Collections.emptyList(), Collections.emptyList(), false){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private final List<ObserverMethod<? super T>> immediateObservers;
    private final List<ObserverMethod<? super T>> transactionObservers;
    private final boolean metadataRequired;

    public static <T> ResolvedObservers<T> of(Set<ObserverMethod<? super T>> observers) {
        if (observers.isEmpty()) {
            return EMPTY;
        }
        boolean metadataRequired = false;
        ArrayList<ObserverMethod<T>> immediateObservers = new ArrayList<ObserverMethod<T>>();
        ArrayList<ObserverMethod<T>> transactionObservers = new ArrayList<ObserverMethod<T>>();
        for (ObserverMethod<T> observer : observers) {
            if (TransactionPhase.IN_PROGRESS == observer.getTransactionPhase()) {
                immediateObservers.add(observer);
            } else {
                transactionObservers.add(observer);
            }
            if (metadataRequired || !Observers.isEventMetadataRequired(observer)) continue;
            metadataRequired = true;
        }
        return new ResolvedObservers<T>(ImmutableList.copyOf(immediateObservers), ImmutableList.copyOf(transactionObservers), metadataRequired);
    }

    private ResolvedObservers(List<ObserverMethod<? super T>> immediateObservers, List<ObserverMethod<? super T>> transactionObservers, boolean metadataRequired) {
        this.immediateObservers = immediateObservers;
        this.transactionObservers = transactionObservers;
        this.metadataRequired = metadataRequired;
    }

    List<ObserverMethod<? super T>> getImmediateObservers() {
        return this.immediateObservers;
    }

    List<ObserverMethod<? super T>> getTransactionObservers() {
        return this.transactionObservers;
    }

    boolean isMetadataRequired() {
        return this.metadataRequired;
    }

    public boolean isEmpty() {
        return false;
    }

    public Set<ObserverMethod<? super T>> getAllObservers() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.immediateObservers)).addAll(this.transactionObservers)).build();
    }
}

