/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.chain;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.context.InterceptionChain;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.InterceptorLogger;

public abstract class AbstractInterceptionChain
implements InterceptionChain {
    private int currentPosition = 0;
    private final List<InterceptorMethodInvocation> interceptorMethodInvocations;

    private static Collection<InterceptorInvocation> buildInterceptorMethodInvocations(Object instance, Method method, Object[] args, InterceptionType interceptionType, InterceptionContext ctx) {
        List<InterceptorMetadata<?>> interceptorList = ctx.getInterceptionModel().getInterceptors(interceptionType, method);
        ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>(interceptorList.size());
        for (InterceptorMetadata<?> interceptorMetadata : interceptorList) {
            interceptorInvocations.add(interceptorMetadata.getInterceptorInvocation(ctx.getInterceptorInstance(interceptorMetadata), interceptionType));
        }
        TargetClassInterceptorMetadata<?> targetClassInterceptorMetadata = ctx.getTargetClassInterceptorMetadata();
        if (targetClassInterceptorMetadata != null && targetClassInterceptorMetadata.isEligible(interceptionType)) {
            interceptorInvocations.add(targetClassInterceptorMetadata.getInterceptorInvocation(instance, interceptionType));
        }
        return interceptorInvocations;
    }

    protected AbstractInterceptionChain(Object instance, Method method, Object[] args, InterceptionType interceptionType, InterceptionContext ctx) {
        this(AbstractInterceptionChain.buildInterceptorMethodInvocations(instance, method, args, interceptionType, ctx));
    }

    protected AbstractInterceptionChain(Collection<InterceptorInvocation> interceptorInvocations) {
        this.interceptorMethodInvocations = new ArrayList<InterceptorMethodInvocation>(interceptorInvocations.size());
        for (InterceptorInvocation interceptorInvocation : interceptorInvocations) {
            this.interceptorMethodInvocations.addAll(interceptorInvocation.getInterceptorMethodInvocations());
        }
    }

    @Override
    public Object invokeNextInterceptor(InvocationContext invocationContext) throws Throwable {
        try {
            if (this.hasNextInterceptor()) {
                return this.invokeNext(invocationContext);
            }
            return this.interceptorChainCompleted(invocationContext);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeNext(InvocationContext invocationContext) throws Exception {
        int oldCurrentPosition = this.currentPosition;
        try {
            InterceptorMethodInvocation nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
            InterceptorLogger.LOG.invokingNextInterceptorInChain(nextInterceptorMethodInvocation.toString());
            if (nextInterceptorMethodInvocation.expectsInvocationContext()) {
                Object object = nextInterceptorMethodInvocation.invoke(invocationContext);
                return object;
            }
            nextInterceptorMethodInvocation.invoke(null);
            while (this.hasNextInterceptor()) {
                nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
                nextInterceptorMethodInvocation.invoke(null);
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.currentPosition = oldCurrentPosition;
        }
    }

    protected abstract Object interceptorChainCompleted(InvocationContext var1) throws Exception;

    @Override
    public boolean hasNextInterceptor() {
        return this.currentPosition < this.interceptorMethodInvocations.size();
    }
}

