/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.unbacked;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotated;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedConstructor;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedField;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedMethod;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class UnbackedAnnotatedType<X>
extends UnbackedAnnotated
implements SlimAnnotatedType<X>,
Serializable {
    private final Class<X> javaClass;
    private final Set<AnnotatedConstructor<X>> constructors;
    private final Set<AnnotatedMethod<? super X>> methods;
    private final Set<AnnotatedField<? super X>> fields;
    private final AnnotatedTypeIdentifier identifier;

    public static <X> UnbackedAnnotatedType<X> additionalAnnotatedType(String contextId, AnnotatedType<X> source, String bdaId, String suffix, SharedObjectCache cache) {
        return new UnbackedAnnotatedType<X>(source, AnnotatedTypeIdentifier.of(contextId, bdaId, source.getJavaClass().getName(), suffix, false), cache);
    }

    public static <X> UnbackedAnnotatedType<X> modifiedAnnotatedType(SlimAnnotatedType<X> originalType, AnnotatedType<X> source, SharedObjectCache cache) {
        AnnotatedTypeIdentifier identifier = AnnotatedTypeIdentifier.forModifiedAnnotatedType((AnnotatedTypeIdentifier)originalType.getIdentifier());
        return new UnbackedAnnotatedType<X>(source, identifier, cache);
    }

    private UnbackedAnnotatedType(AnnotatedType<X> source, AnnotatedTypeIdentifier identifier, SharedObjectCache cache) {
        super(source.getBaseType(), source.getTypeClosure(), source.getAnnotations());
        this.javaClass = source.getJavaClass();
        HashSet<AnnotatedConstructor<X>> constructors = new HashSet<AnnotatedConstructor<X>>(source.getConstructors().size());
        for (AnnotatedConstructor<X> constructor : source.getConstructors()) {
            constructors.add(UnbackedAnnotatedConstructor.of(constructor, this, cache));
        }
        this.constructors = WeldCollections.immutableSet(constructors);
        HashSet<AnnotatedMethod<X>> methods = new HashSet<AnnotatedMethod<X>>(source.getMethods().size());
        for (AnnotatedMethod<X> originalMethod : source.getMethods()) {
            methods.add(UnbackedAnnotatedMethod.of(originalMethod, this, cache));
        }
        this.methods = WeldCollections.immutableSet(methods);
        HashSet<AnnotatedField<X>> fields = new HashSet<AnnotatedField<X>>(source.getFields().size());
        for (AnnotatedField<X> originalField : source.getFields()) {
            fields.add(UnbackedAnnotatedField.of(originalField, this, cache));
        }
        this.fields = WeldCollections.immutableSet(fields);
        this.identifier = identifier;
    }

    @Override
    public Class<X> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.constructors;
    }

    @Override
    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.methods;
    }

    @Override
    public Set<AnnotatedField<? super X>> getFields() {
        return this.fields;
    }

    public String toString() {
        return Formats.formatAnnotatedType(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SlimAnnotatedType.SerializationProxy(this.getIdentifier());
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.proxyRequired();
    }

    @Override
    public void clear() {
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnbackedAnnotatedType) {
            UnbackedAnnotatedType that = (UnbackedAnnotatedType)Reflections.cast(obj);
            return Objects.equal(this.identifier, that.identifier);
        }
        return false;
    }

    @Override
    public AnnotatedTypeIdentifier getIdentifier() {
        return this.identifier;
    }
}

