/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery.jandex;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.discovery.AbstractDiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexClassFileServices;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexFileSystemBeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexIndexBeanArchiveHandler;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.collections.ImmutableSet;

public class JandexDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    static final String INDEX_ATTRIBUTE_NAME = JandexDiscoveryStrategy.class.getPackage().getName() + ".index";
    private static final int ANNOTATION = 8192;
    private Set<DotName> beanDefiningAnnotations;
    private CompositeIndex cindex;
    private JandexClassFileServices classFileServices;

    public JandexDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        super(resourceLoader, bootstrap, initialBeanDefiningAnnotations);
        this.registerHandler(new JandexIndexBeanArchiveHandler());
        this.registerHandler(new JandexFileSystemBeanArchiveHandler());
    }

    @Override
    public ClassFileServices getClassFileServices() {
        return this.classFileServices;
    }

    @Override
    protected void beforeDiscovery(Collection<BeanArchiveBuilder> builders) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        for (BeanArchiveBuilder builder : builders) {
            IndexView index = (IndexView)builder.getAttribute(INDEX_ATTRIBUTE_NAME);
            indexes.add(index);
        }
        this.cindex = CompositeIndex.create(indexes);
        this.beanDefiningAnnotations = this.buildBeanDefiningAnnotationSet(this.initialBeanDefiningAnnotations, this.cindex);
        this.classFileServices = new JandexClassFileServices(this);
    }

    @Override
    protected WeldBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        Iterator<String> classIterator = builder.getClassIterator();
        while (classIterator.hasNext()) {
            String className = classIterator.next();
            ClassInfo cinfo = this.cindex.getClassByName(DotName.createSimple((String)className));
            if (this.containsBeanDefiningAnnotation(cinfo.annotations().keySet())) continue;
            classIterator.remove();
        }
        return builder.build();
    }

    private Set<DotName> buildBeanDefiningAnnotationSet(Set<Class<? extends Annotation>> initialBeanDefiningAnnotations, CompositeIndex index) {
        ImmutableSet.Builder beanDefiningAnnotations = ImmutableSet.builder();
        for (Class<? extends Annotation> annotation : initialBeanDefiningAnnotations) {
            DotName annotationDotName = DotName.createSimple((String)annotation.getName());
            if (this.isMetaAnnotation(annotation)) {
                for (AnnotationInstance instance : index.getAnnotations(annotationDotName)) {
                    ClassInfo classInfo;
                    if (!(instance.target() instanceof ClassInfo) || ((classInfo = (ClassInfo)instance.target()).flags() & 0x2000) == 0) continue;
                    beanDefiningAnnotations.add((Object)classInfo.name());
                }
                continue;
            }
            beanDefiningAnnotations.add((Object)annotationDotName);
        }
        return beanDefiningAnnotations.build();
    }

    private boolean isMetaAnnotation(Class<? extends Annotation> annotation) {
        Target target = annotation.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        if (target.value() == null) {
            return false;
        }
        for (ElementType elementType : target.value()) {
            if (!ElementType.ANNOTATION_TYPE.equals((Object)elementType)) continue;
            return true;
        }
        return false;
    }

    private boolean containsBeanDefiningAnnotation(Set<DotName> annotations) {
        for (DotName name : annotations) {
            if (!this.beanDefiningAnnotations.contains(name)) continue;
            return true;
        }
        return false;
    }

    public CompositeIndex getCompositeJandexIndex() {
        return this.cindex;
    }
}

