/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Stereotype;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.discovery.AbstractDiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.FileSystemBeanArchiveHandler;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.reflection.Reflections;

public class ReflectionDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private final List<Class<? extends Annotation>> metaAnnotations = ImmutableList.of((Object[])new Class[]{Stereotype.class, NormalScope.class});

    public ReflectionDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        super(resourceLoader, bootstrap, initialBeanDefiningAnnotations);
        this.registerHandler(new FileSystemBeanArchiveHandler());
    }

    @Override
    protected WeldBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        CommonLogger.LOG.reflectionFallback();
        Iterator<String> classIterator = builder.getClassIterator();
        while (classIterator.hasNext()) {
            String className = classIterator.next();
            Class clazz = Reflections.loadClass((String)className, (ResourceLoader)this.resourceLoader);
            if (this.hasBeanDefiningAnnotation(clazz, this.initialBeanDefiningAnnotations)) continue;
            classIterator.remove();
        }
        return builder.build();
    }

    private boolean hasBeanDefiningAnnotation(Class<?> clazz, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        for (Class<? extends Annotation> beanDefiningAnnotation : initialBeanDefiningAnnotations) {
            if (!clazz.isAnnotationPresent(beanDefiningAnnotation)) continue;
            return true;
        }
        for (Class<? extends Annotation> metaAnnotation : this.metaAnnotations) {
            if (!org.jboss.weld.environment.util.Reflections.hasBeanDefiningMetaAnnotationSpecified(clazz.getAnnotations(), metaAnnotation)) continue;
            return true;
        }
        return false;
    }
}

