/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.microcontainer.deployer.env;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.webbeans.integration.microcontainer.deployer.env.WebBeanDiscoveryEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeansBootstrapDeployer
extends AbstractSimpleRealDeployer<WebBeanDiscoveryEnvironment> {
    public WebBeansBootstrapDeployer() {
        super(WebBeanDiscoveryEnvironment.class);
        this.setTopLevelOnly(true);
        this.setStage(DeploymentStages.PRE_REAL);
        this.addOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit, WebBeanDiscoveryEnvironment env) throws DeploymentException {
        String unitName = unit.getName();
        String envName = unitName + "_JBossWebBeanDiscovery";
        BeanMetaDataBuilder envWrapper = BeanMetaDataBuilder.createBuilder((String)envName, (String)"org.jboss.webbeans.integration.jbossas.bootstrap.JBossWebBeanDiscovery");
        envWrapper.addConstructorParameter(WebBeanDiscoveryEnvironment.class.getName(), (Object)env);
        unit.addAttachment(envName + "_" + BeanMetaData.class.getSimpleName(), (Object)envWrapper.getBeanMetaData());
        String bootstrapName = unitName + "_WebBeansBootstrap";
        BeanMetaDataBuilder bootstrap = BeanMetaDataBuilder.createBuilder((String)bootstrapName, (String)"org.jboss.webbeans.bootstrap.WebBeansBootstrap");
        bootstrap.addPropertyMetaData("webBeanDiscovery", bootstrap.createInject((Object)envName));
        bootstrap.addPropertyMetaData("ejbDiscovery", this.createEjbConnector("JBossEjbDiscovery", "org.jboss.webbeans.integration.ejb.JBossEjbDiscovery", unit));
        bootstrap.addPropertyMetaData("ejbResolver", this.createEjbConnector("JBossEjbResolver", "org.jboss.webbeans.integration.ejb.JBossEjbResolver", unit));
        bootstrap.addPropertyMetaData("transactionServices", bootstrap.createInject((Object)"JBossTransactionServices"));
        bootstrap.addPropertyMetaData("applicationContext", (Object)this.createBeanStore());
        bootstrap.setCreate("initialize");
        bootstrap.setStart("boot");
        bootstrap.setDestroy("shutdown");
        bootstrap.addDependency((Object)"RealTransactionManager");
        unit.addAttachment(bootstrapName + "_" + BeanMetaData.class.getSimpleName(), (Object)bootstrap.getBeanMetaData());
    }

    protected BeanStore createBeanStore() {
        return new ConcurrentHashMapBeanStore();
    }

    protected ValueMetaData createEjbConnector(String name, String bean, DeploymentUnit unit) {
        String beanName = unit.getName() + "_" + name;
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)bean);
        builder.setFactory(name);
        builder.setFactoryMethod("createBean");
        builder.addPropertyMetaData("deploymentUnit", (Object)unit);
        unit.addAttachment(beanName + "_" + BeanMetaData.class.getSimpleName(), (Object)builder.getBeanMetaData());
        return builder.createInject((Object)beanName);
    }
}

