/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.webbeans.integration.microcontainer.deployer.metadata;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;

/**
 * WebBeans aware metadata deployer.
 * It looks for webbeans.xml in metadata.
 *
 * @param <T> exact metadata type
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public abstract class WebBeansAwareMetadataDeployer<T> extends AbstractSimpleVFSRealDeployer<T>
{
   /** Do we allow null wb xml file */
   private boolean optionalWebBeansXml;

   public WebBeansAwareMetadataDeployer(Class<T> input)
   {
      super(input);
      setStage(DeploymentStages.POST_PARSE);
      addOutput(input); // we just modify this
   }

   public void deploy(VFSDeploymentUnit unit, T deployment) throws DeploymentException
   {
      VirtualFile wbXml = unit.getMetaDataFile("beans.xml");
      if (wbXml != null || optionalWebBeansXml)
         internalDeploy(unit, deployment, wbXml);
   }

   /**
    * Deploy.
    *
    * @param unit the deployment unit
    * @param deployment the deployment metadata
    * @param wbXml web beans xml
    * @throws DeploymentException for any deployment error
    */
   protected abstract void internalDeploy(VFSDeploymentUnit unit, T deployment, VirtualFile wbXml) throws DeploymentException;

   /**
    * Set optional wb xml file.
    *
    * @param optionalWebBeansXml the optional wb xml file flag
    */
   public void setOptionalWebBeansXml(boolean optionalWebBeansXml)
   {
      this.optionalWebBeansXml = optionalWebBeansXml;
   }
}